/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.metadata.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.search.metadata.FieldDescriptor;
import org.hibernate.search.metadata.PropertyDescriptor;

public class PropertyDescriptorImpl
implements PropertyDescriptor {
    private final String name;
    private final Set<FieldDescriptor> fieldDescriptors;
    private final boolean id;

    public PropertyDescriptorImpl(String name, boolean id, Set<FieldDescriptor> fieldDescriptors) {
        this.name = name;
        this.fieldDescriptors = Collections.unmodifiableSet(new HashSet<FieldDescriptor>(fieldDescriptors));
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isId() {
        return this.id;
    }

    @Override
    public Set<FieldDescriptor> getIndexedFields() {
        return this.fieldDescriptors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PropertyDescriptorImpl that = (PropertyDescriptorImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PropertyDescriptorImpl{");
        sb.append("name='").append(this.name).append('\'');
        sb.append(", fieldDescriptors=").append(this.fieldDescriptors);
        sb.append(", id=").append(this.id);
        sb.append('}');
        return sb.toString();
    }
}

