/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.ehcache;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import net.sf.ehcache.Element;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.dialect.lock.OptimisticForceIncrementLockingStrategy;
import org.hibernate.dialect.lock.OptimisticLockingStrategy;
import org.hibernate.dialect.lock.PessimisticForceIncrementLockingStrategy;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableKey;
import org.hibernate.ogm.datastore.ehcache.dialect.impl.SerializableMapAssociationSnapshot;
import org.hibernate.ogm.datastore.ehcache.impl.Cache;
import org.hibernate.ogm.datastore.ehcache.impl.EhcacheDatastoreProvider;
import org.hibernate.ogm.datastore.map.impl.MapHelpers;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.datastore.spi.Association;
import org.hibernate.ogm.datastore.spi.AssociationContext;
import org.hibernate.ogm.datastore.spi.AssociationOperation;
import org.hibernate.ogm.datastore.spi.AssociationSnapshot;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.datastore.spi.TupleContext;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.Key;
import org.hibernate.ogm.grid.RowKey;
import org.hibernate.ogm.id.spi.NextValueRequest;
import org.hibernate.ogm.massindex.batchindexing.Consumer;
import org.hibernate.persister.entity.Lockable;

public class EhcacheDialect
extends BaseGridDialect {
    EhcacheDatastoreProvider datastoreProvider;

    public EhcacheDialect(EhcacheDatastoreProvider datastoreProvider) {
        this.datastoreProvider = datastoreProvider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        if (lockMode == LockMode.PESSIMISTIC_FORCE_INCREMENT) {
            return new PessimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC) {
            return new OptimisticLockingStrategy(lockable, lockMode);
        }
        if (lockMode == LockMode.OPTIMISTIC_FORCE_INCREMENT) {
            return new OptimisticForceIncrementLockingStrategy(lockable, lockMode);
        }
        throw new UnsupportedOperationException("LockMode " + lockMode + " is not supported by the Ehcache GridDialect");
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        Cache<SerializableKey> entityCache = this.datastoreProvider.getEntityCache();
        Element element = entityCache.get(new SerializableKey((Key)key));
        if (element != null) {
            return this.createTuple(element);
        }
        return null;
    }

    private Tuple createTuple(Element element) {
        return new Tuple((TupleSnapshot)new MapTupleSnapshot((Map)element.getObjectValue()));
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        Cache<SerializableKey> entityCache = this.datastoreProvider.getEntityCache();
        HashMap tuple = new HashMap();
        entityCache.put(new Element((Serializable)new SerializableKey((Key)key), tuple));
        return new Tuple((TupleSnapshot)new MapTupleSnapshot(tuple));
    }

    public void updateTuple(Tuple tuple, EntityKey key, TupleContext tupleContext) {
        Map entityRecord = ((MapTupleSnapshot)tuple.getSnapshot()).getMap();
        MapHelpers.applyTupleOpsOnMap((Tuple)tuple, (Map)entityRecord);
        Cache<SerializableKey> entityCache = this.datastoreProvider.getEntityCache();
        entityCache.put(new Element((Object)new SerializableKey((Key)key), (Object)entityRecord));
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.datastoreProvider.getEntityCache().remove(new SerializableKey((Key)key));
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<SerializableKey> associationCache = this.datastoreProvider.getAssociationCache();
        Element element = associationCache.get(new SerializableKey((Key)key));
        if (element == null) {
            return null;
        }
        Map associationRows = (Map)element.getObjectValue();
        return new Association((AssociationSnapshot)new SerializableMapAssociationSnapshot(associationRows));
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        Cache<SerializableKey> associationCache = this.datastoreProvider.getAssociationCache();
        HashMap<SerializableKey, Map<String, Object>> association = new HashMap<SerializableKey, Map<String, Object>>();
        associationCache.put(new Element((Object)new SerializableKey((Key)key), association));
        return new Association((AssociationSnapshot)new SerializableMapAssociationSnapshot(association));
    }

    public void updateAssociation(Association association, AssociationKey key, AssociationContext associationContext) {
        Map<SerializableKey, Map<String, Object>> associationRows = ((SerializableMapAssociationSnapshot)association.getSnapshot()).getUnderlyingMap();
        for (AssociationOperation action : association.getOperations()) {
            switch (action.getType()) {
                case CLEAR: {
                    associationRows.clear();
                }
                case PUT_NULL: 
                case PUT: {
                    associationRows.put(new SerializableKey((Key)action.getKey()), MapHelpers.tupleToMap((Tuple)action.getValue()));
                    break;
                }
                case REMOVE: {
                    associationRows.remove(new SerializableKey((Key)action.getKey()));
                }
            }
        }
        Cache<SerializableKey> associationCache = this.datastoreProvider.getAssociationCache();
        associationCache.put(new Element((Object)new SerializableKey((Key)key), associationRows));
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        this.datastoreProvider.getAssociationCache().remove(new SerializableKey((Key)key));
    }

    public Tuple createTupleAssociation(AssociationKey associationKey, RowKey rowKey) {
        return new Tuple();
    }

    public Number nextValue(NextValueRequest request) {
        SerializableKey key;
        Cache<SerializableKey> cache = this.datastoreProvider.getIdentifierCache();
        Element previousValue = cache.get(key = new SerializableKey((Key)request.getKey()));
        if (previousValue == null) {
            previousValue = cache.putIfAbsent(new Element((Serializable)key, (Serializable)Integer.valueOf(request.getInitialValue())));
        }
        if (previousValue != null) {
            while (!cache.replace(previousValue, new Element((Serializable)key, (Serializable)Integer.valueOf((Integer)previousValue.getObjectValue() + request.getIncrement())))) {
                previousValue = cache.get(key);
            }
            return (Integer)previousValue.getObjectValue() + request.getIncrement();
        }
        return request.getInitialValue();
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean isStoredInEntityStructure(AssociationKey associationKey, AssociationContext associationContext) {
        return false;
    }

    public void forEachTuple(Consumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        Cache<SerializableKey> entityCache = this.datastoreProvider.getEntityCache();
        for (SerializableKey key : entityCache.getKeys()) {
            for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
                if (!key.getTable().equals(entityKeyMetadata.getTable())) continue;
                Element element = entityCache.get(key);
                consumer.consume(this.createTuple(element));
            }
        }
    }
}

