/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.association.spi;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.ogm.datastore.spi.TupleSnapshot;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.RowKey;

public class AssociationRow<R>
implements TupleSnapshot {
    private final AssociationKey associationKey;
    private final AssociationRowAccessor<R> accessor;
    private final R row;
    private final Set<String> columnNames;
    private final RowKey rowKey;

    public AssociationRow(AssociationKey associationKey, AssociationRowAccessor<R> accessor, R row) {
        this.associationKey = associationKey;
        this.accessor = accessor;
        this.row = row;
        this.columnNames = Collections.unmodifiableSet(AssociationRow.buildColumnNames(associationKey, accessor.getColumnNames(row)));
        this.rowKey = AssociationRow.buildRowKey(associationKey, row, accessor);
    }

    private static Set<String> buildColumnNames(AssociationKey associationKey, Set<String> columnsFromRow) {
        HashSet<String> columnNames = new HashSet<String>(columnsFromRow.size() + associationKey.getColumnNames().length);
        columnNames.addAll(columnsFromRow);
        Collections.addAll(columnNames, associationKey.getColumnNames());
        return columnNames;
    }

    private static <R> RowKey buildRowKey(AssociationKey associationKey, R row, AssociationRowAccessor<R> accessor) {
        String table = associationKey.getTable();
        String[] columnNames = associationKey.getMetadata().getRowKeyColumnNames();
        Object[] columnValues = new Object[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            String columnName = columnNames[i];
            columnValues[i] = associationKey.getMetadata().isKeyColumn(columnName) ? associationKey.getColumnValue(columnName) : accessor.get(row, columnName);
        }
        return new RowKey(table, columnNames, columnValues, null);
    }

    @Override
    public Object get(String column) {
        return this.associationKey.getMetadata().isKeyColumn(column) ? this.associationKey.getColumnValue(column) : this.accessor.get(this.row, column);
    }

    @Override
    public boolean isEmpty() {
        return this.columnNames.isEmpty();
    }

    @Override
    public Set<String> getColumnNames() {
        return this.columnNames;
    }

    public RowKey getKey() {
        return this.rowKey;
    }

    public static interface AssociationRowAccessor<R> {
        public Set<String> getColumnNames(R var1);

        public Object get(R var1, String var2);
    }
}

