/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.io.Serializable;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.dialect.GridDialectLogger;
import org.hibernate.ogm.dialect.spi.QueryableGridDialect;
import org.hibernate.ogm.query.spi.BackendQuery;
import org.hibernate.ogm.query.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.util.ClosableIterator;
import org.hibernate.ogm.util.impl.CoreLogCategories;
import org.hibernate.ogm.util.impl.Log;
import org.jboss.logging.Logger;

public class QueryableGridDialectLogger<T extends Serializable>
extends GridDialectLogger
implements QueryableGridDialect<T> {
    private static final Log log = (Log)Logger.getMessageLogger(Log.class, (String)CoreLogCategories.DATASTORE_ACCESS.toString());
    private final QueryableGridDialect<T> gridDialect;

    public QueryableGridDialectLogger(QueryableGridDialect<T> gridDialect) {
        super(gridDialect);
        this.gridDialect = gridDialect;
    }

    @Override
    public ClosableIterator<Tuple> executeBackendQuery(BackendQuery<T> query, QueryParameters queryParameters) {
        log.tracef("Executing backend query: %1$s", query.getQuery());
        return this.gridDialect.executeBackendQuery(query, queryParameters);
    }

    @Override
    public ParameterMetadataBuilder getParameterMetadataBuilder() {
        return this.gridDialect.getParameterMetadataBuilder();
    }

    @Override
    public T parseNativeQuery(String nativeQuery) {
        return this.gridDialect.parseNativeQuery(nativeQuery);
    }
}

