/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid;

import java.util.Arrays;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.grid.Key;

public final class EntityKey
implements Key {
    private final EntityKeyMetadata keyMetadata;
    private final int hashCode;
    private final Object[] columnValues;

    public EntityKey(EntityKeyMetadata keyMetadata, Object[] values) {
        this.keyMetadata = keyMetadata;
        this.columnValues = values;
        this.hashCode = this.generateHashCode();
    }

    @Override
    public String getTable() {
        return this.keyMetadata.getTable();
    }

    @Override
    public Object[] getColumnValues() {
        return this.columnValues;
    }

    @Override
    public String[] getColumnNames() {
        return this.keyMetadata.getColumnNames();
    }

    public EntityKeyMetadata getMetadata() {
        return this.keyMetadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("EntityKey");
        sb.append("{table='").append(this.keyMetadata.getTable()).append('\'');
        String[] columnNames = this.keyMetadata.getColumnNames();
        sb.append(", columnNames=").append(columnNames == null ? "null" : Arrays.asList(columnNames).toString());
        sb.append(", columnValues=").append(this.columnValues == null ? "null" : Arrays.asList(this.columnValues).toString());
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || EntityKey.class != o.getClass()) {
            return false;
        }
        EntityKey entityKey = (EntityKey)o;
        if (!Arrays.equals(this.columnValues, entityKey.columnValues)) {
            return false;
        }
        return this.keyMetadata.equals(entityKey.keyMetadata);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generateHashCode() {
        int result = this.keyMetadata.hashCode();
        result = 31 * result + Arrays.hashCode(this.columnValues);
        return result;
    }
}

