/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.grid.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.grid.EntityKey;
import org.hibernate.ogm.grid.RowKey;

public class RowKeyBuilder {
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> indexColumnNames = new ArrayList<String>(3);
    private String tableName;
    private Tuple tuple;
    private EntityKey entityKey;

    public RowKeyBuilder addColumns(String ... columns) {
        for (String columnName : columns) {
            this.columnNames.add(columnName);
        }
        return this;
    }

    public RowKeyBuilder addIndexColumns(String ... columns) {
        for (String columnName : columns) {
            this.columnNames.add(columnName);
            this.indexColumnNames.add(columnName);
        }
        return this;
    }

    public RowKeyBuilder tableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public RowKeyBuilder entityKey(EntityKey entityKey) {
        this.entityKey = entityKey;
        return this;
    }

    public RowKey build() {
        String[] columnNamesArray = this.columnNames.toArray(new String[this.columnNames.size()]);
        int length = columnNamesArray.length;
        Object[] columnValuesArray = new Object[length];
        for (int index = 0; index < length; ++index) {
            columnValuesArray[index] = this.tuple.get(columnNamesArray[index]);
        }
        return new RowKey(this.tableName, columnNamesArray, columnValuesArray, this.entityKey);
    }

    public RowKeyBuilder values(Tuple tuple) {
        this.tuple = tuple;
        return this;
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public String[] getIndexColumnNames() {
        return this.indexColumnNames.toArray(new String[this.indexColumnNames.size()]);
    }
}

