/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.loader.nativeloader;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.engine.query.spi.sql.NativeSQLQueryReturn;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.loader.custom.Return;
import org.hibernate.loader.custom.RootReturn;
import org.hibernate.loader.custom.sql.SQLQueryReturnProcessor;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class BackendCustomQuery<T extends Serializable>
implements CustomQuery,
Serializable {
    private static final Log LOG = LoggerFactory.make();
    private final String queryString;
    private final T queryObject;
    private final Set<String> querySpaces;
    private final List<Return> customQueryReturns;
    private final EntityKeyMetadata singleEntityKeyMetadata;

    public BackendCustomQuery(String queryString, T query, NativeSQLQueryReturn[] queryReturns, Set<String> querySpaces, SessionFactoryImplementor factory) throws HibernateException {
        LOG.tracev("Starting processing of NoSQL query [{0}]", queryString);
        this.queryString = queryString;
        this.queryObject = query;
        SQLQueryReturnProcessor processor = new SQLQueryReturnProcessor(queryReturns, factory);
        processor.process();
        this.customQueryReturns = Collections.unmodifiableList(processor.generateCustomReturns(false));
        this.querySpaces = querySpaces != null ? Collections.unmodifiableSet(querySpaces) : Collections.emptySet();
        this.singleEntityKeyMetadata = BackendCustomQuery.determineSingleEntityKeyMetadata(factory, this.customQueryReturns);
    }

    private static EntityKeyMetadata determineSingleEntityKeyMetadata(SessionFactoryImplementor sessionFactory, List<Return> customQueryReturns) {
        EntityKeyMetadata metadata = null;
        for (Return queryReturn : customQueryReturns) {
            if (!(queryReturn instanceof RootReturn)) continue;
            if (metadata != null) {
                return null;
            }
            RootReturn rootReturn = (RootReturn)queryReturn;
            OgmEntityPersister persister = (OgmEntityPersister)sessionFactory.getEntityPersister(rootReturn.getEntityName());
            metadata = new EntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
        }
        return metadata;
    }

    @Deprecated
    public String getSQL() {
        return this.getQueryString();
    }

    public String getQueryString() {
        return this.queryString;
    }

    public T getQueryObject() {
        return this.queryObject;
    }

    public Set<String> getQuerySpaces() {
        return this.querySpaces;
    }

    public Map<?, ?> getNamedParameterBindPoints() {
        return Collections.emptyMap();
    }

    public List<Return> getCustomQueryReturns() {
        return this.customQueryReturns;
    }

    public EntityKeyMetadata getSingleEntityKeyMetadataOrNull() {
        return this.singleEntityKeyMetadata;
    }

    public String toString() {
        return this.queryObject != null ? this.queryObject.toString() : this.queryString;
    }
}

