/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.batchindexing;

import java.util.concurrent.CountDownLatch;
import org.hibernate.CacheMode;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.grid.EntityKeyMetadata;
import org.hibernate.ogm.massindex.batchindexing.OptionallyWrapInJTATransaction;
import org.hibernate.ogm.massindex.batchindexing.TupleIndexer;
import org.hibernate.ogm.persister.OgmEntityPersister;
import org.hibernate.search.backend.impl.batch.BatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class BatchIndexingWorkspace
implements Runnable {
    private static final Log log = LoggerFactory.make();
    private final SearchFactoryImplementor searchFactory;
    private final SessionFactoryImplementor sessionFactory;
    private final Class<?> indexedType;
    private final MassIndexerProgressMonitor monitor;
    private final CacheMode cacheMode;
    private final BatchBackend batchBackend;
    private final GridDialect gridDialect;
    private final CountDownLatch endAllSignal;

    public BatchIndexingWorkspace(GridDialect gridDialect, SearchFactoryImplementor searchFactoryImplementor, SessionFactoryImplementor sessionFactory, Class<?> entityType, CacheMode cacheMode, CountDownLatch endAllSignal, MassIndexerProgressMonitor monitor, BatchBackend backend) {
        this.gridDialect = gridDialect;
        this.indexedType = entityType;
        this.searchFactory = searchFactoryImplementor;
        this.sessionFactory = sessionFactory;
        this.cacheMode = cacheMode;
        this.endAllSignal = endAllSignal;
        this.batchBackend = backend;
        this.monitor = monitor;
    }

    private EntityKeyMetadata getEntityKeyMetadata() {
        OgmEntityPersister persister = (OgmEntityPersister)this.sessionFactory.getEntityPersister(this.indexedType.getName());
        return new EntityKeyMetadata(persister.getTableName(), persister.getRootTableIdentifierColumnNames());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ErrorHandler errorHandler = this.searchFactory.getErrorHandler();
        try {
            EntityKeyMetadata keyMetadata = this.getEntityKeyMetadata();
            TupleIndexer consumer = new TupleIndexer(this.indexedType, this.monitor, this.sessionFactory, this.searchFactory, this.cacheMode, this.batchBackend, errorHandler);
            this.gridDialect.forEachTuple(new OptionallyWrapInJTATransaction((SessionFactory)this.sessionFactory, errorHandler, consumer), keyMetadata);
        }
        catch (RuntimeException re) {
            errorHandler.handleException(log.massIndexerUnexpectedErrorMessage(), (Throwable)re);
        }
        finally {
            this.endAllSignal.countDown();
        }
    }
}

