/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.massindex.batchindexing;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;

public class ProducerConsumerQueue<T> {
    private static final int DEFAULT_BUFF_LENGHT = 1000;
    private static final Object EXIT_TOKEN = new Object();
    private final BlockingQueue<Object> queue;
    private final AtomicInteger producersToWaitFor;

    public ProducerConsumerQueue(int producersToWaitFor) {
        this(1000, producersToWaitFor);
    }

    public ProducerConsumerQueue(int queueLenght, int producersToWaitFor) {
        this.queue = new ArrayBlockingQueue<Object>(queueLenght);
        this.producersToWaitFor = new AtomicInteger(producersToWaitFor);
    }

    public T take() throws InterruptedException {
        Object obj = this.queue.take();
        if (obj == EXIT_TOKEN) {
            this.queue.put(EXIT_TOKEN);
            return null;
        }
        return (T)obj;
    }

    public void put(T obj) throws InterruptedException {
        this.queue.put(obj);
    }

    public void producerStopping() {
        int activeProducers = this.producersToWaitFor.decrementAndGet();
        if (activeProducers == 0) {
            try {
                this.queue.put(EXIT_TOKEN);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

