/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type;

import java.io.Serializable;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.internal.ForeignKeys;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.datastore.spi.Tuple;
import org.hibernate.ogm.type.GridType;
import org.hibernate.ogm.type.GridTypeDelegatingToCoreType;
import org.hibernate.ogm.type.TypeTranslator;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.Type;

public class ManyToOneType
extends GridTypeDelegatingToCoreType
implements GridType {
    private final TypeTranslator typeTranslator;
    private final org.hibernate.type.ManyToOneType delegate;

    public ManyToOneType(org.hibernate.type.ManyToOneType type, TypeTranslator typeTranslator) {
        super((Type)type);
        this.delegate = type;
        this.typeTranslator = typeTranslator;
    }

    @Override
    public Object nullSafeGet(Tuple rs, String[] names, SessionImplementor session, Object owner) throws HibernateException {
        return this.resolve(this.hydrate(rs, names, session, owner), session, owner);
    }

    @Override
    public Object nullSafeGet(Tuple rs, String name, SessionImplementor session, Object owner) throws HibernateException {
        return this.nullSafeGet(rs, new String[]{name}, session, owner);
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, boolean[] settable, SessionImplementor session) throws HibernateException {
        GridType idGridType = this.getIdGridType(session);
        idGridType.nullSafeSet(resultset, this.getIdentifier(value, session), names, settable, session);
    }

    private GridType getIdGridType(SessionImplementor session) {
        Type idType = this.delegate.getIdentifierOrUniqueKeyType((Mapping)session.getFactory());
        GridType idGridType = this.typeTranslator.getType(idType);
        return idGridType;
    }

    @Override
    public void nullSafeSet(Tuple resultset, Object value, String[] names, SessionImplementor session) throws HibernateException {
        GridType idGridType = this.getIdGridType(session);
        idGridType.nullSafeSet(resultset, this.getIdentifier(value, session), names, session);
    }

    @Override
    public Object hydrate(Tuple rs, String[] names, SessionImplementor session, Object owner) throws HibernateException {
        Serializable id = (Serializable)this.getIdGridType(session).nullSafeGet(rs, names, session, null);
        this.scheduleBatchLoadIfNeeded(id, session);
        return id;
    }

    private void scheduleBatchLoadIfNeeded(Serializable id, SessionImplementor session) throws MappingException {
        if (id != null) {
            EntityPersister persister = session.getFactory().getEntityPersister(this.delegate.getAssociatedEntityName());
            EntityKey entityKey = session.generateEntityKey(id, persister);
            if (!session.getPersistenceContext().containsEntity(entityKey)) {
                session.getPersistenceContext().getBatchFetchQueue().addBatchLoadableEntityKey(entityKey);
            }
        }
    }

    protected final Object getIdentifier(Object value, SessionImplementor session) throws HibernateException {
        boolean isNotEmbedded = this.isNotEmbedded(session);
        if (isNotEmbedded) {
            return value;
        }
        String associatedEntityName = this.delegate.getAssociatedEntityName();
        if (this.delegate.isReferenceToPrimaryKey()) {
            return ForeignKeys.getEntityIdentifierIfNotUnsaved((String)associatedEntityName, (Object)value, (SessionImplementor)session);
        }
        if (value == null) {
            return null;
        }
        throw new NotYetImplementedException("@ManyToOne using a non-pk unique key not yet supported by OGM");
    }

    protected boolean isNotEmbedded(SessionImplementor session) {
        return false;
    }
}

