/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.util.configurationreader.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.util.configurationreader.impl.ClassPropertyReaderContext;
import org.hibernate.ogm.util.configurationreader.impl.PropertyValidator;
import org.hibernate.ogm.util.impl.Contracts;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.StringHelper;

public abstract class PropertyReaderContext<T> {
    private static final Log log = LoggerFactory.make();
    private final Object configuredValue;
    private final String propertyName;
    private final Class<T> targetType;
    private final ClassLoaderService classLoaderService;
    private T defaultValue;
    private boolean isRequired;
    private final List<PropertyValidator<T>> validators;

    PropertyReaderContext(ClassLoaderService classLoaderService, Object configuredValue, String propertyName, Class<T> targetType) {
        this.classLoaderService = classLoaderService;
        this.configuredValue = configuredValue;
        this.propertyName = propertyName;
        this.targetType = targetType;
        this.validators = new ArrayList<PropertyValidator<T>>();
    }

    PropertyReaderContext(ClassLoaderService classLoaderService, Object configuredValue, String propertyName, Class<T> targetType, T defaultValue, boolean isRequired, List<PropertyValidator<T>> validators) {
        this.classLoaderService = classLoaderService;
        this.configuredValue = configuredValue;
        this.propertyName = propertyName;
        this.targetType = targetType;
        this.defaultValue = defaultValue;
        this.isRequired = isRequired;
        this.validators = validators;
    }

    public PropertyReaderContext<T> withDefault(T defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public PropertyReaderContext<T> required() {
        this.isRequired = true;
        return this;
    }

    public PropertyReaderContext<T> withValidator(PropertyValidator<T> validator) {
        this.validators.add(validator);
        return this;
    }

    public ClassPropertyReaderContext<T> instantiate() {
        Contracts.assertNotNull(this.classLoaderService, "classLoaderService");
        return new ClassPropertyReaderContext<T>(this.classLoaderService, this.configuredValue, this.propertyName, this.targetType, this.defaultValue, this.isRequired, this.validators);
    }

    public T getValue() {
        if (this.isRequired && StringHelper.isNullOrEmptyString(this.configuredValue)) {
            throw log.missingConfigurationProperty(this.propertyName);
        }
        T typedValue = this.getTypedValue();
        for (PropertyValidator<T> validator : this.validators) {
            validator.validate(typedValue);
        }
        return typedValue;
    }

    protected abstract T getTypedValue();

    protected Object getConfiguredValue() {
        return this.configuredValue;
    }

    protected String getPropertyName() {
        return this.propertyName;
    }

    protected Class<T> getTargetType() {
        return this.targetType;
    }

    protected T getDefaultValue() {
        return this.defaultValue;
    }
}

