/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.impl;

import java.util.Map;
import org.hibernate.ogm.datastore.couchdb.CouchDBDialect;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.impl.CouchDBDatastore;
import org.hibernate.ogm.datastore.couchdb.impl.CouchDBConfiguration;
import org.hibernate.ogm.datastore.couchdb.impl.CouchDBSchemaSchemaDefiner;
import org.hibernate.ogm.datastore.couchdb.logging.impl.Log;
import org.hibernate.ogm.datastore.couchdb.logging.impl.LoggerFactory;
import org.hibernate.ogm.datastore.couchdb.util.impl.DatabaseIdentifier;
import org.hibernate.ogm.datastore.spi.BaseDatastoreProvider;
import org.hibernate.ogm.dialect.GridDialect;
import org.hibernate.ogm.dialect.spi.SchemaDefiner;
import org.hibernate.ogm.util.configurationreader.impl.ConfigurationPropertyReader;
import org.hibernate.service.spi.Configurable;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.Startable;
import org.hibernate.service.spi.Stoppable;

public class CouchDBDatastoreProvider
extends BaseDatastoreProvider
implements Startable,
Stoppable,
ServiceRegistryAwareService,
Configurable {
    private static final Log logger = LoggerFactory.getLogger();
    private CouchDBDatastore datastore;
    private CouchDBConfiguration configuration;

    public void configure(Map configurationValues) {
        this.configuration = new CouchDBConfiguration(new ConfigurationPropertyReader(configurationValues));
    }

    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
    }

    public void stop() {
        if (this.datastore != null) {
            this.datastore.shutDown();
            this.datastore = null;
        }
    }

    public void start() {
        if (this.isDatastoreNotInitialized()) {
            this.datastore = CouchDBDatastore.newInstance(this.getDatabase(), this.configuration.isCreateDatabase());
        }
    }

    public Class<? extends GridDialect> getDefaultDialect() {
        return CouchDBDialect.class;
    }

    public Class<? extends SchemaDefiner> getSchemaDefinerType() {
        return CouchDBSchemaSchemaDefiner.class;
    }

    public CouchDBDatastore getDataStore() {
        return this.datastore;
    }

    private boolean isDatastoreNotInitialized() {
        return this.datastore == null;
    }

    private DatabaseIdentifier getDatabase() {
        try {
            return new DatabaseIdentifier(this.configuration.getHost(), this.configuration.getPort(), this.configuration.getDatabaseName(), this.configuration.getUsername(), this.configuration.getPassword());
        }
        catch (Exception e) {
            throw logger.malformedDataBaseUrl(e, this.configuration.getHost(), this.configuration.getPort(), this.configuration.getDatabaseName());
        }
    }
}

