/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.util.impl;

import java.util.regex.Pattern;
import org.hibernate.ogm.grid.AssociationKey;
import org.hibernate.ogm.grid.EntityKey;

public class Identifier {
    private static final String COLUMN_VALUES_SEPARATOR = "_";
    private static final Pattern escapingPattern = Pattern.compile("_");

    public static String createEntityId(EntityKey key) {
        return key.getTable() + ":" + Identifier.fromColumnValues(key.getColumnNames()) + ":" + Identifier.fromColumnValues(key.getColumnValues());
    }

    public static String createAssociationId(AssociationKey key) {
        return key.getTable() + ":" + Identifier.fromColumnValues(key.getColumnNames()) + ":" + Identifier.fromColumnValues(key.getColumnValues());
    }

    private static String fromColumnValues(Object[] columnValues) {
        String id = "";
        for (int i = 0; i < columnValues.length; ++i) {
            id = id + Identifier.escapeCharsValuesUsedAsColumnValuesSeparator(columnValues[i]) + COLUMN_VALUES_SEPARATOR;
        }
        return id;
    }

    private static String escapeCharsValuesUsedAsColumnValuesSeparator(Object columnValue) {
        String value = String.valueOf(columnValue);
        return escapingPattern.matcher(value).replaceAll("/_");
    }
}

