/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.StoreFileType;

public enum StoreFile20 {
    NODE_STORE("NodeStore", ".nodestore.db"),
    NODE_LABEL_STORE("ArrayPropertyStore", ".nodestore.db.labels"),
    PROPERTY_STORE("PropertyStore", ".propertystore.db"),
    PROPERTY_ARRAY_STORE("ArrayPropertyStore", ".propertystore.db.arrays"),
    PROPERTY_STRING_STORE("StringPropertyStore", ".propertystore.db.strings"),
    PROPERTY_KEY_TOKEN_STORE("PropertyIndexStore", ".propertystore.db.index"),
    PROPERTY_KEY_TOKEN_NAMES_STORE("StringPropertyStore", ".propertystore.db.index.keys"),
    RELATIONSHIP_STORE("RelationshipStore", ".relationshipstore.db"),
    RELATIONSHIP_TYPE_TOKEN_STORE("RelationshipTypeStore", ".relationshiptypestore.db"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("StringPropertyStore", ".relationshiptypestore.db.names"),
    LABEL_TOKEN_STORE("LabelTokenStore", ".labeltokenstore.db"),
    LABEL_TOKEN_NAMES_STORE("StringPropertyStore", ".labeltokenstore.db.names"),
    SCHEMA_STORE("SchemaStore", ".schemastore.db"),
    RELATIONSHIP_GROUP_STORE("RelationshipGroupStore", ".relationshipgroupstore.db", false),
    NEO_STORE("NeoStore", "");

    private final String typeDescriptor;
    private final String storeFileNamePart;
    private final boolean existsInBoth;

    private StoreFile20(String typeDescriptor, String storeFileNamePart) {
        this(typeDescriptor, storeFileNamePart, true);
    }

    private StoreFile20(String typeDescriptor, String storeFileNamePart, boolean existsInBoth) {
        this.typeDescriptor = typeDescriptor;
        this.storeFileNamePart = storeFileNamePart;
        this.existsInBoth = existsInBoth;
    }

    public String legacyVersion() {
        return this.typeDescriptor + " " + "v0.A.1";
    }

    public String typeDescriptor() {
        return this.typeDescriptor;
    }

    public String fileName(StoreFileType type) {
        return type.augment("neostore" + this.storeFileNamePart);
    }

    public String storeFileName() {
        return this.fileName(StoreFileType.STORE);
    }

    public String idFileName() {
        return this.fileName(StoreFileType.ID);
    }

    public static Iterable<StoreFile20> legacyStoreFiles() {
        Predicate<StoreFile20> predicate = new Predicate<StoreFile20>(){

            @Override
            public boolean accept(StoreFile20 item) {
                return item.existsInBoth;
            }
        };
        Iterable<StoreFile20> storeFiles = StoreFile20.currentStoreFiles();
        return Iterables.filter(predicate, storeFiles);
    }

    public static Iterable<StoreFile20> currentStoreFiles() {
        return Iterables.iterable(StoreFile20.values());
    }

    public static void move(FileSystemAbstraction fs, File fromDirectory, File toDirectory, Iterable<StoreFile20> files, boolean allowSkipNonExistentFiles, boolean allowOverwriteTarget, StoreFileType ... types) throws IOException {
        for (StoreFile20 storeFile : files) {
            for (StoreFileType type : types) {
                StoreFile20.moveFile(fs, storeFile.fileName(type), fromDirectory, toDirectory, allowSkipNonExistentFiles, allowOverwriteTarget);
            }
        }
    }

    static void moveFile(FileSystemAbstraction fs, String fileName, File fromDirectory, File toDirectory, boolean allowSkipNonExistentFiles, boolean allowOverwriteTarget) throws IOException {
        File sourceFile = new File(fromDirectory, fileName);
        if (allowSkipNonExistentFiles && !fs.fileExists(sourceFile)) {
            return;
        }
        File toFile = new File(toDirectory, fileName);
        if (allowOverwriteTarget && fs.fileExists(toFile)) {
            fs.deleteFile(toFile);
        }
        fs.moveToDirectory(sourceFile, toDirectory);
    }

    public static void ensureStoreVersion(FileSystemAbstraction fs, File storeDir, Iterable<StoreFile20> files) throws IOException {
        StoreFile20.ensureStoreVersion(fs, storeDir, files, "v0.A.3");
    }

    public static void ensureStoreVersion(FileSystemAbstraction fs, File storeDir, Iterable<StoreFile20> files, String version) throws IOException {
        for (StoreFile20 file : files) {
            StoreFile20.setStoreVersionTrailer(fs, new File(storeDir, file.storeFileName()), CommonAbstractStore.buildTypeDescriptorAndVersion(file.typeDescriptor(), version));
        }
        NeoStore.setStoreVersion(fs, new File(storeDir, "neostore"), NeoStore.versionStringToLong(version));
    }

    private static void setStoreVersionTrailer(FileSystemAbstraction fs, File targetStoreFileName, String versionTrailer) throws IOException {
        byte[] trailer = UTF8.encode(versionTrailer);
        long fileSize = 0L;
        try (StoreChannel fileChannel = fs.open(targetStoreFileName, "rw");){
            fileSize = fileChannel.size();
            fileChannel.position(fileChannel.size() - (long)trailer.length);
            fileChannel.write(ByteBuffer.wrap(trailer));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("size:" + fileSize + ", trailer:" + trailer.length + " for " + targetStoreFileName);
        }
    }

    public static void deleteIdFile(FileSystemAbstraction fs, File directory, StoreFile20 ... stores) {
        for (StoreFile20 store : stores) {
            fs.deleteFile(new File(directory, store.idFileName()));
        }
    }

    public static void deleteStoreFile(FileSystemAbstraction fs, File directory, StoreFile20 ... stores) {
        for (StoreFile20 store : stores) {
            fs.deleteFile(new File(directory, store.storeFileName()));
        }
    }
}

