/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.neo4j.graphdb.DependencyResolver;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.IteratorWrapper;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.NeoStoreUtil;
import org.neo4j.kernel.impl.nioneo.store.NodeRecord;
import org.neo4j.kernel.impl.nioneo.store.RelationshipRecord;
import org.neo4j.kernel.impl.storemigration.StoreFile20;
import org.neo4j.kernel.impl.storemigration.StoreFileType;
import org.neo4j.kernel.impl.storemigration.StoreMigrationParticipant;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;
import org.neo4j.kernel.impl.storemigration.UpgradableDatabase;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19Store;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.Legacy20Store;
import org.neo4j.kernel.impl.storemigration.monitoring.MigrationProgressMonitor;
import org.neo4j.unsafe.impl.batchimport.Configuration;
import org.neo4j.unsafe.impl.batchimport.ParallellBatchImporter;
import org.neo4j.unsafe.impl.batchimport.cache.IdMapper;
import org.neo4j.unsafe.impl.batchimport.cache.IdMappers;
import org.neo4j.unsafe.impl.batchimport.input.InputNode;
import org.neo4j.unsafe.impl.batchimport.input.InputRelationship;
import org.neo4j.unsafe.impl.batchimport.staging.CoarseBoundedProgressExecutionMonitor;

public class StoreMigrator
extends StoreMigrationParticipant.Adapter {
    private static final Object[] NO_PROPERTIES = new Object[0];
    private final MigrationProgressMonitor progressMonitor;
    private final UpgradableDatabase upgradableDatabase;
    private final Config config;
    private String versionToUpgradeFrom;

    public StoreMigrator(MigrationProgressMonitor progressMonitor, FileSystemAbstraction fileSystem) {
        this(progressMonitor, new UpgradableDatabase(new StoreVersionCheck(fileSystem)), new Config());
    }

    public StoreMigrator(MigrationProgressMonitor progressMonitor, UpgradableDatabase upgradableDatabase, Config config) {
        this.progressMonitor = progressMonitor;
        this.upgradableDatabase = upgradableDatabase;
        this.config = config;
    }

    @Override
    public boolean needsMigration(FileSystemAbstraction fileSystem, File storeDir) throws IOException {
        NeoStoreUtil neoStoreUtil = new NeoStoreUtil(storeDir, fileSystem);
        String versionAsString = NeoStore.versionLongToString(neoStoreUtil.getStoreVersion());
        boolean sameVersion = "v0.A.3".equals(versionAsString);
        if (!sameVersion) {
            this.upgradableDatabase.checkUpgradeable(storeDir);
        }
        return !sameVersion;
    }

    @Override
    public void migrate(FileSystemAbstraction fileSystem, File storeDir, File migrationDir, DependencyResolver dependencyResolver) throws IOException {
        this.versionToUpgradeFrom = this.upgradableDatabase.checkUpgradeable(storeDir);
        this.progressMonitor.started();
        LegacyStore legacyStore = this.versionToUpgradeFrom.equals("v0.A.0") ? new Legacy19Store(fileSystem, new File(storeDir, "neostore")) : new Legacy20Store(fileSystem, new File(storeDir, "neostore"));
        CoarseBoundedProgressExecutionMonitor executionMonitor = new CoarseBoundedProgressExecutionMonitor(legacyStore.getNodeStoreReader().getMaxId(), legacyStore.getRelStoreReader().getMaxId()){

            @Override
            protected void percent(int percent) {
                StoreMigrator.this.progressMonitor.percentComplete(percent);
            }
        };
        ParallellBatchImporter importer = new ParallellBatchImporter(migrationDir.getAbsolutePath(), fileSystem, new Configuration.OverrideFromConfig(this.config), Collections.emptyList(), executionMonitor);
        Iterable<InputNode> nodes = this.legacyNodesAsInput(legacyStore);
        Iterable<InputRelationship> relationships = this.legacyRelationshipsAsInput(legacyStore);
        IdMapper idMapper = IdMappers.actualIds();
        importer.doImport(nodes, relationships, idMapper);
        this.progressMonitor.finished();
        importer.shutdown();
        legacyStore.close();
    }

    private StoreFile20[] allExcept(StoreFile20 ... exceptions) {
        ArrayList<StoreFile20> result = new ArrayList<StoreFile20>();
        result.addAll(Arrays.asList(StoreFile20.values()));
        for (StoreFile20 except : exceptions) {
            result.remove((Object)except);
        }
        return result.toArray(new StoreFile20[result.size()]);
    }

    private Iterable<InputRelationship> legacyRelationshipsAsInput(LegacyStore legacyStore) {
        final LegacyRelationshipStoreReader reader = legacyStore.getRelStoreReader();
        return new Iterable<InputRelationship>(){

            @Override
            public Iterator<InputRelationship> iterator() {
                Iterator<RelationshipRecord> source;
                try {
                    source = reader.iterator(0L);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputRelationship, RelationshipRecord>(source){

                    @Override
                    protected InputRelationship underlyingObjectToObject(RelationshipRecord record) {
                        return new InputRelationship(record.getId(), NO_PROPERTIES, record.getNextProp(), record.getFirstNode(), record.getSecondNode(), null, record.getType());
                    }
                };
            }
        };
    }

    private Iterable<InputNode> legacyNodesAsInput(LegacyStore legacyStore) {
        final LegacyNodeStoreReader reader = legacyStore.getNodeStoreReader();
        final String[] NO_LABELS = new String[]{};
        return new Iterable<InputNode>(){

            @Override
            public Iterator<InputNode> iterator() {
                Iterator<NodeRecord> source;
                try {
                    source = reader.iterator();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return new IteratorWrapper<InputNode, NodeRecord>(source){

                    @Override
                    protected InputNode underlyingObjectToObject(NodeRecord record) {
                        return new InputNode(record.getId(), NO_PROPERTIES, record.getNextProp(), NO_LABELS, record.getLabelField());
                    }
                };
            }
        };
    }

    @Override
    public void moveMigratedFiles(FileSystemAbstraction fileSystem, File migrationDir, File storeDir, File leftOversDir) throws IOException {
        StoreFile20.deleteIdFile(fileSystem, migrationDir, this.allExcept(StoreFile20.RELATIONSHIP_GROUP_STORE));
        StoreFile20[] filesToDelete = this.versionToUpgradeFrom.equals("v0.A.0") ? this.allExcept(StoreFile20.NODE_STORE, StoreFile20.RELATIONSHIP_STORE, StoreFile20.RELATIONSHIP_GROUP_STORE, StoreFile20.LABEL_TOKEN_STORE, StoreFile20.NODE_LABEL_STORE, StoreFile20.LABEL_TOKEN_NAMES_STORE, StoreFile20.SCHEMA_STORE) : this.allExcept(StoreFile20.NODE_STORE, StoreFile20.RELATIONSHIP_STORE, StoreFile20.RELATIONSHIP_GROUP_STORE, StoreFile20.SCHEMA_STORE);
        StoreFile20.deleteStoreFile(fileSystem, migrationDir, filesToDelete);
        StoreFile20.move(fileSystem, storeDir, leftOversDir, IteratorUtil.asIterable(StoreFile20.NODE_STORE, StoreFile20.RELATIONSHIP_STORE), false, false, StoreFileType.STORE);
        StoreFile20.move(fileSystem, migrationDir, storeDir, StoreFile20.currentStoreFiles(), true, true, StoreFileType.values());
        StoreFile20.ensureStoreVersion(fileSystem, storeDir, StoreFile20.currentStoreFiles());
    }

    @Override
    public void cleanup(FileSystemAbstraction fileSystem, File migrationDir) throws IOException {
        for (StoreFile20 storeFile : StoreFile20.values()) {
            fileSystem.deleteFile(new File(migrationDir, storeFile.storeFileName()));
            fileSystem.deleteFile(new File(migrationDir, storeFile.idFileName()));
        }
    }

    public String toString() {
        return "Kernel StoreMigrator";
    }
}

