/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration.legacystore.v19;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.helpers.UTF8;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.helpers.collection.ResourceClosingIterator;
import org.neo4j.kernel.impl.nioneo.store.CommonAbstractStore;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyNodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyRelationshipStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.LegacyStore;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19NodeStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.Legacy19PropertyIndexStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.LegacyLogIoUtil;
import org.neo4j.kernel.impl.storemigration.legacystore.v19.LegacyPropertyStoreReader;
import org.neo4j.kernel.impl.storemigration.legacystore.v20.LegacyRelationship20StoreReader;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;

public class Legacy19Store
implements LegacyStore {
    public static final String LEGACY_VERSION = "v0.A.0";
    private final File storageFileName;
    private final Collection<Closeable> allStoreReaders = new ArrayList<Closeable>();
    private Legacy19NodeStoreReader nodeStoreReader;
    private Legacy19PropertyIndexStoreReader propertyIndexReader;
    private LegacyPropertyStoreReader propertyStoreReader;
    private LegacyRelationshipStoreReader relStoreReader;
    private final FileSystemAbstraction fs;

    public Legacy19Store(FileSystemAbstraction fs, File storageFileName) throws IOException {
        this.fs = fs;
        this.storageFileName = storageFileName;
        Legacy19Store.assertLegacyAndCurrentVersionHaveSameLength(LEGACY_VERSION, "v0.A.3");
        this.initStorage();
    }

    static void assertLegacyAndCurrentVersionHaveSameLength(String legacyVersion, String currentVersion) {
        if (UTF8.encode(legacyVersion).length != UTF8.encode(currentVersion).length) {
            throw new IllegalStateException("Encoded version string length must remain the same between versions");
        }
    }

    protected void initStorage() throws IOException {
        this.nodeStoreReader = new Legacy19NodeStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".nodestore.db"));
        this.allStoreReaders.add(this.nodeStoreReader);
        this.propertyIndexReader = new Legacy19PropertyIndexStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db.index"));
        this.allStoreReaders.add(this.propertyIndexReader);
        this.propertyStoreReader = new LegacyPropertyStoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".propertystore.db"));
        this.allStoreReaders.add(this.propertyStoreReader);
        this.relStoreReader = new LegacyRelationship20StoreReader(this.fs, new File(this.getStorageFileName().getPath() + ".relationshipstore.db"));
        this.allStoreReaders.add(this.relStoreReader);
    }

    @Override
    public File getStorageFileName() {
        return this.storageFileName;
    }

    public static long getUnsignedInt(ByteBuffer buf) {
        return (long)buf.getInt() & 0xFFFFFFFFL;
    }

    protected static long longFromIntAndMod(long base, long modifier) {
        return modifier == 0L && base == 0xFFFFFFFFL ? -1L : base | modifier;
    }

    @Override
    public void close() throws IOException {
        for (Closeable storeReader : this.allStoreReaders) {
            storeReader.close();
        }
    }

    private void copyStore(File targetBaseStorageFileName, String storeNamePart, String versionTrailer) throws IOException {
        File targetStoreFileName = new File(targetBaseStorageFileName.getPath() + storeNamePart);
        this.fs.copyFile(new File(this.storageFileName + storeNamePart), targetStoreFileName);
        this.setStoreVersionTrailer(targetStoreFileName, versionTrailer);
        this.fs.copyFile(new File(this.storageFileName + storeNamePart + ".id"), new File(targetBaseStorageFileName + storeNamePart + ".id"));
    }

    private void setStoreVersionTrailer(File targetStoreFileName, String versionTrailer) throws IOException {
        try (StoreChannel fileChannel = this.fs.open(targetStoreFileName, "rw");){
            byte[] trailer = UTF8.encode(versionTrailer);
            fileChannel.position(fileChannel.size() - (long)trailer.length);
            fileChannel.write(ByteBuffer.wrap(trailer));
        }
    }

    public void copyNeoStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), "", neoStore.getTypeAndVersionDescriptor());
    }

    public void copyRelationshipStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshipstore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipStore"));
    }

    public void copyRelationshipTypeTokenStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db", CommonAbstractStore.buildTypeDescriptorAndVersion("RelationshipTypeStore"));
    }

    public void copyRelationshipTypeTokenNameStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".relationshiptypestore.db.names", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicStringPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.strings", CommonAbstractStore.buildTypeDescriptorAndVersion("StringPropertyStore"));
    }

    public void copyDynamicArrayPropertyStore(NeoStore neoStore) throws IOException {
        this.copyStore(neoStore.getStorageFileName(), ".propertystore.db.arrays", CommonAbstractStore.buildTypeDescriptorAndVersion("ArrayPropertyStore"));
    }

    @Override
    public LegacyNodeStoreReader getNodeStoreReader() {
        return this.nodeStoreReader;
    }

    @Override
    public LegacyRelationshipStoreReader getRelStoreReader() {
        return this.relStoreReader;
    }

    public Legacy19PropertyIndexStoreReader getPropertyIndexReader() {
        return this.propertyIndexReader;
    }

    public LegacyPropertyStoreReader getPropertyStoreReader() {
        return this.propertyStoreReader;
    }

    static void readIntoBuffer(StoreChannel fileChannel, ByteBuffer buffer, int nrOfBytes) {
        buffer.clear();
        buffer.limit(nrOfBytes);
        try {
            fileChannel.read(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buffer.flip();
    }

    @Override
    public void copyLegacyIndexStoreFile(File toDirectory) throws IOException {
        File legacyDirectory = this.storageFileName.getParentFile();
        File fromFile = new File(legacyDirectory, "index.db");
        if (fromFile.exists()) {
            File toFile = new File(toDirectory, "index.db");
            this.fs.copyFile(fromFile, toFile);
        }
    }

    public StoreChannel beginTranslatingLastTransactionLog(NeoStore neoStore) throws IOException {
        File lastLegacyTransactionLog = this.findLastTransactionLog();
        if (lastLegacyTransactionLog == null) {
            return null;
        }
        File newTransactionLog = new File(neoStore.getStorageFileName().getParent(), lastLegacyTransactionLog.getName());
        return this.fs.open(newTransactionLog, "rw");
    }

    private File findLastTransactionLog() {
        Pattern logFileName;
        FilenameFilter logFiles;
        File legacyDirectory = this.storageFileName.getParentFile();
        Object[] files = legacyDirectory.listFiles(logFiles = new FilenameFilter(logFileName = Pattern.compile("nioneo_logical\\.log\\.v.*")){
            final /* synthetic */ Pattern val$logFileName;
            {
                this.val$logFileName = pattern;
            }

            @Override
            public boolean accept(File dir, String name) {
                return this.val$logFileName.matcher(name).find();
            }
        });
        if (files != null && files.length > 0) {
            Arrays.sort(files);
            return files[files.length - 1];
        }
        return null;
    }

    public ResourceIterator<LogEntry> iterateLastTransactionLogEntries(LogBuffer logBuffer) throws IOException {
        File legacyTransactionLog = this.findLastTransactionLog();
        final StoreChannel channel = this.fs.open(legacyTransactionLog, "r");
        final ByteBuffer buffer = ByteBuffer.allocate(100000);
        long[] header = LegacyLogIoUtil.readLogHeader(buffer, channel, false);
        if (header != null) {
            ByteBuffer headerBuf = ByteBuffer.allocate(16);
            LogEntryWriterv1.writeLogHeader(headerBuf, header[0], header[1]);
            logBuffer.put(headerBuf.array());
        }
        Resource resource = new Resource(){

            @Override
            public void close() {
                try {
                    channel.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to close legacy log channel", e);
                }
            }
        };
        return ResourceClosingIterator.newResourceIterator(resource, new PrefetchingIterator<LogEntry>(){

            @Override
            protected LogEntry fetchNextOrNull() {
                try {
                    return LegacyLogIoUtil.readEntry(buffer, channel);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read legacy log entry", e);
                }
            }
        });
    }
}

