/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.DaemonThreadFactory;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;

public class Neo4jJobScheduler
extends LifecycleAdapter
implements JobScheduler {
    private final StringLogger log;
    private final String id;
    private ExecutorService executor;
    private ScheduledThreadPoolExecutor scheduledExecutor;
    private final ConcurrentMap<Runnable, ScheduledFuture<?>> recurringJobs = new ConcurrentHashMap();

    public Neo4jJobScheduler(StringLogger log) {
        this.log = log;
        this.id = this.getClass().getSimpleName();
    }

    public Neo4jJobScheduler(String id, StringLogger log) {
        this.log = log;
        this.id = id;
    }

    @Override
    public void init() {
        this.executor = Executors.newCachedThreadPool(new DaemonThreadFactory("Neo4j " + this.id));
        this.scheduledExecutor = new ScheduledThreadPoolExecutor(2);
    }

    @Override
    public void schedule(JobScheduler.Group group, Runnable job) {
        this.executor.submit(job);
    }

    @Override
    public void scheduleRecurring(JobScheduler.Group group, Runnable runnable, long period, TimeUnit timeUnit) {
        this.scheduleRecurring(group, runnable, 0L, period, timeUnit);
    }

    @Override
    public void scheduleRecurring(JobScheduler.Group group, Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        ScheduledFuture<?> scheduled = this.scheduledExecutor.scheduleAtFixedRate(runnable, initialDelay, period, timeUnit);
        if (this.recurringJobs.putIfAbsent(runnable, scheduled) != null) {
            scheduled.cancel(true);
            throw new IllegalArgumentException(runnable + " is already scheduled. Please implement a unique " + ".equals() method for each runnable you would like to execute.");
        }
    }

    @Override
    public void cancelRecurring(JobScheduler.Group group, Runnable runnable) {
        ScheduledFuture toCancel = (ScheduledFuture)this.recurringJobs.remove(runnable);
        if (toCancel != null) {
            toCancel.cancel(false);
        }
    }

    @Override
    public void shutdown() throws Throwable {
        RuntimeException exception = null;
        try {
            if (this.executor != null) {
                this.executor.shutdownNow();
                this.executor.awaitTermination(5L, TimeUnit.SECONDS);
                this.executor = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = new RuntimeException(e);
        }
        try {
            if (this.scheduledExecutor != null) {
                this.scheduledExecutor.shutdown();
                this.scheduledExecutor.awaitTermination(5L, TimeUnit.SECONDS);
                this.scheduledExecutor = null;
            }
        }
        catch (RuntimeException e) {
            exception = e;
        }
        catch (InterruptedException e) {
            exception = new RuntimeException(e);
        }
        if (exception != null) {
            throw new RuntimeException("Unable to shut down job scheduler properly.", exception);
        }
    }
}

