/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.util.Arrays;
import org.neo4j.collection.primitive.hopscotch.PowerOfTwoQuantizedTable;

public abstract class IntArrayBasedKeyTable<VALUE>
extends PowerOfTwoQuantizedTable<VALUE> {
    protected int[] table;
    protected final VALUE singleValue;
    private final int itemsPerEntry;

    protected IntArrayBasedKeyTable(int itemsPerEntry, int h, VALUE singleValue) {
        this(IntArrayBasedKeyTable.baseCapacity(h), itemsPerEntry, h, singleValue);
    }

    protected IntArrayBasedKeyTable(int capacity, int itemsPerEntry, int h, VALUE singleValue) {
        super(capacity, h);
        this.singleValue = singleValue;
        this.itemsPerEntry = itemsPerEntry;
        this.initializeTable();
        this.clearTable();
    }

    protected void initializeTable() {
        this.table = new int[this.capacity * this.itemsPerEntry];
    }

    protected void clearTable() {
        Arrays.fill(this.table, -1);
    }

    @Override
    public void put(int index, long key, VALUE value) {
        int actualIndex = this.index(index);
        this.internalPut(actualIndex, key, value);
        ++this.size;
    }

    @Override
    public VALUE remove(int index) {
        int actualIndex = this.index(index);
        VALUE value = this.value(index);
        this.internalRemove(actualIndex);
        --this.size;
        return value;
    }

    @Override
    public long move(int fromIndex, int toIndex) {
        long key = this.key(fromIndex);
        VALUE value = this.value(fromIndex);
        int actualFromIndex = this.index(fromIndex);
        this.internalRemove(actualFromIndex);
        int actualToIndex = this.index(toIndex);
        this.internalPut(actualToIndex, key, value);
        return key;
    }

    protected abstract void internalRemove(int var1);

    protected abstract void internalPut(int var1, long var2, VALUE var4);

    @Override
    public VALUE value(int index) {
        return this.singleValue;
    }

    @Override
    public VALUE putValue(int index, VALUE value) {
        return value;
    }

    @Override
    public long hopBits(int index) {
        return ((long)this.table[this.index(index) + this.itemsPerEntry - 1] | 0xFFFFFFFF00000000L) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    private int hopBit(int hd) {
        return 1 << hd;
    }

    @Override
    public void putHopBit(int index, int hd) {
        int n = this.index(index) + this.itemsPerEntry - 1;
        this.table[n] = this.table[n] & ~this.hopBit(hd);
    }

    @Override
    public void moveHopBit(int index, int hd, int delta) {
        int n = this.index(index) + this.itemsPerEntry - 1;
        this.table[n] = this.table[n] ^ (this.hopBit(hd) | this.hopBit(hd + delta));
    }

    @Override
    public void removeHopBit(int index, int hd) {
        int n = this.index(index) + this.itemsPerEntry - 1;
        this.table[n] = this.table[n] | this.hopBit(hd);
    }

    protected int index(int index) {
        return index * this.itemsPerEntry;
    }

    @Override
    public void clear() {
        this.clearTable();
        super.clear();
    }
}

