/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.hopscotch.Table;

public abstract class PowerOfTwoQuantizedTable<VALUE>
implements Table<VALUE> {
    protected final int h;
    protected final int capacity;
    protected int tableMask;
    protected int size;

    protected PowerOfTwoQuantizedTable(int capacity, int h) {
        if (h < 4 || h > 32) {
            throw new IllegalArgumentException("h needs to be 4 <= h <= 32, was " + h);
        }
        this.h = h;
        this.capacity = PowerOfTwoQuantizedTable.quantize(capacity);
        this.tableMask = Integer.highestOneBit(this.capacity) - 1;
    }

    public static int baseCapacity(int h) {
        return h << 1;
    }

    protected static int quantize(int capacity) {
        int candidate = Integer.highestOneBit(capacity);
        return candidate == capacity ? candidate : candidate << 1;
    }

    @Override
    public int h() {
        return this.h;
    }

    @Override
    public int mask() {
        return this.tableMask;
    }

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public int version() {
        return 0;
    }

    @Override
    public int version(int index) {
        return 0;
    }

    @Override
    public long nullKey() {
        return -1L;
    }

    @Override
    public Table<VALUE> grow() {
        return this.newInstance(this.capacity << 1);
    }

    protected abstract Table<VALUE> newInstance(int var1);

    public String toString() {
        return String.format("hopscotch-table[%s|capacity:%d, size:%d, usage:%f]", this.getClass().getSimpleName(), this.capacity, this.size, (double)this.size / (double)this.capacity);
    }

    @Override
    public void close() {
    }
}

