/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveIntObjectMap;
import org.neo4j.collection.primitive.PrimitiveIntObjectVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractIntHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveIntObjectHashMap<VALUE>
extends AbstractIntHopScotchCollection<VALUE>
implements PrimitiveIntObjectMap<VALUE> {
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveIntObjectHashMap(Table<VALUE> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public VALUE put(int key, VALUE value) {
        return HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, value, this);
    }

    @Override
    public boolean containsKey(int key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public VALUE get(int key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public VALUE remove(int key) {
        return HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key);
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    @Override
    public void visitEntries(PrimitiveIntObjectVisitor<VALUE> visitor) {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            int key = (int)this.table.key(i);
            if ((long)key == nullKey) continue;
            Object value = this.table.value(i);
            visitor.visited(key, value);
        }
    }
}

