/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import org.neo4j.collection.primitive.PrimitiveLongLongMap;
import org.neo4j.collection.primitive.PrimitiveLongLongVisitor;
import org.neo4j.collection.primitive.hopscotch.AbstractLongHopScotchCollection;
import org.neo4j.collection.primitive.hopscotch.HopScotchHashingAlgorithm;
import org.neo4j.collection.primitive.hopscotch.Table;

public class PrimitiveLongLongHashMap
extends AbstractLongHopScotchCollection<long[]>
implements PrimitiveLongLongMap {
    private final long[] transport = new long[1];
    private final HopScotchHashingAlgorithm.Monitor monitor;

    public PrimitiveLongLongHashMap(Table<long[]> table, HopScotchHashingAlgorithm.Monitor monitor) {
        super(table);
        this.monitor = monitor;
    }

    @Override
    public long put(long key, long value) {
        return this.unpack(HopScotchHashingAlgorithm.put(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key, this.pack(value), this));
    }

    @Override
    public boolean containsKey(long key) {
        return HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key) != null;
    }

    @Override
    public long get(long key) {
        return this.unpack((long[])HopScotchHashingAlgorithm.get(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public long remove(long key) {
        return this.unpack((long[])HopScotchHashingAlgorithm.remove(this.table, this.monitor, HopScotchHashingAlgorithm.DEFAULT_HASHING, key));
    }

    @Override
    public int size() {
        return this.table.size();
    }

    @Override
    public String toString() {
        return this.table.toString();
    }

    private long[] pack(long value) {
        this.transport[0] = value;
        return this.transport;
    }

    private long unpack(long[] result) {
        return result != null ? result[0] : -1L;
    }

    @Override
    public void visitEntries(PrimitiveLongLongVisitor visitor) {
        long nullKey = this.table.nullKey();
        int capacity = this.table.capacity();
        for (int i = 0; i < capacity; ++i) {
            long[] value;
            long key = this.table.key(i);
            if (key == nullKey || (value = (long[])this.table.value(i)) == null) continue;
            visitor.visited(key, value[0]);
        }
    }
}

