/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.cfg.impl;

import org.hibernate.ogm.cfg.Configurable;
import org.hibernate.ogm.datastore.spi.DatastoreConfiguration;
import org.hibernate.ogm.options.navigation.GlobalContext;
import org.hibernate.ogm.options.navigation.impl.AppendableConfigurationContext;
import org.hibernate.ogm.options.navigation.impl.ConfigurationContextImpl;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class ConfigurableImpl
implements Configurable {
    private static final Log log = LoggerFactory.make();
    private final AppendableConfigurationContext context = new AppendableConfigurationContext();

    @Override
    public <D extends DatastoreConfiguration<G>, G extends GlobalContext<?, ?>> G configureOptionsFor(Class<D> datastoreType) {
        D configuration = this.newInstance(datastoreType);
        return configuration.getConfigurationBuilder(new ConfigurationContextImpl(this.context));
    }

    public AppendableConfigurationContext getContext() {
        return this.context;
    }

    private <D extends DatastoreConfiguration<?>> D newInstance(Class<D> datastoreType) {
        try {
            return (D)((DatastoreConfiguration)datastoreType.newInstance());
        }
        catch (Exception e) {
            throw log.unableToInstantiateType(datastoreType.getName(), e);
        }
    }
}

