/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.map.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.datastore.map.impl.MapAssociationSnapshot;
import org.hibernate.ogm.datastore.map.impl.MapTupleSnapshot;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationOperation;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleOperation;
import org.hibernate.ogm.model.spi.TupleSnapshot;

public final class MapHelpers {
    private MapHelpers() {
    }

    public static void applyTupleOpsOnMap(Tuple tuple, Map<String, Object> map) {
        for (TupleOperation action : tuple.getOperations()) {
            switch (action.getType()) {
                case PUT_NULL: 
                case PUT: {
                    map.put(action.getColumn(), action.getValue());
                    break;
                }
                case REMOVE: {
                    map.remove(action.getColumn());
                }
            }
        }
    }

    public static Map<String, Object> tupleToMap(Tuple tuple) {
        if (tuple == null) {
            return null;
        }
        TupleSnapshot snapshotInstance = tuple.getSnapshot();
        Map<Object, Object> snapshot = snapshotInstance.isEmpty() ? Collections.emptyMap() : ((MapTupleSnapshot)snapshotInstance).getMap();
        HashMap<String, Object> map = new HashMap<String, Object>(snapshot);
        MapHelpers.applyTupleOpsOnMap(tuple, map);
        return map;
    }

    public static void updateAssociation(Association association, AssociationKey key) {
        Map<RowKey, Map<String, Object>> underlyingMap = ((MapAssociationSnapshot)association.getSnapshot()).getUnderlyingMap();
        for (AssociationOperation action : association.getOperations()) {
            switch (action.getType()) {
                case CLEAR: {
                    underlyingMap.clear();
                }
                case PUT_NULL: 
                case PUT: {
                    underlyingMap.put(action.getKey(), MapHelpers.tupleToMap(action.getValue()));
                    break;
                }
                case REMOVE: {
                    underlyingMap.remove(action.getKey());
                }
            }
        }
    }
}

