/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.boot.registry.StandardServiceInitiator;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.ogm.datastore.spi.DatastoreProvider;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.impl.BatchOperationsDelegator;
import org.hibernate.ogm.dialect.impl.GridDialectLogger;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.util.configurationreader.impl.DefaultClassPropertyReaderContext;
import org.hibernate.ogm.util.configurationreader.impl.Instantiator;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class GridDialectInitiator
implements StandardServiceInitiator<GridDialect> {
    public static final GridDialectInitiator INSTANCE = new GridDialectInitiator();
    private static final Log log = LoggerFactory.make();

    private GridDialectInitiator() {
    }

    public Class<GridDialect> getServiceInitiated() {
        return GridDialect.class;
    }

    public GridDialect initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        DatastoreProvider datastore = (DatastoreProvider)registry.getService(DatastoreProvider.class);
        ConfigurationPropertyReader propertyReader = new ConfigurationPropertyReader(configurationValues, (ClassLoaderService)registry.getService(ClassLoaderService.class));
        return (GridDialect)((DefaultClassPropertyReaderContext)((DefaultClassPropertyReaderContext)propertyReader.property("hibernate.ogm.datastore.grid_dialect", GridDialect.class).instantiate()).withDefaultImplementation(((DatastoreProvider)registry.getService(DatastoreProvider.class)).getDefaultDialect())).withInstantiator(new GridDialectInstantiator(datastore)).getValue();
    }

    private static class GridDialectInstantiator
    implements Instantiator<GridDialect> {
        private final DatastoreProvider datastore;

        public GridDialectInstantiator(DatastoreProvider datastore) {
            this.datastore = datastore;
        }

        @Override
        public GridDialect newInstance(Class<? extends GridDialect> clazz) {
            try {
                GridDialect gridDialect;
                Constructor<?> injector = null;
                for (Constructor<?> constructor : clazz.getConstructors()) {
                    Class<?>[] parameterTypes = constructor.getParameterTypes();
                    if (parameterTypes.length != 1 || !DatastoreProvider.class.isAssignableFrom(parameterTypes[0])) continue;
                    injector = constructor;
                    break;
                }
                if (injector == null) {
                    log.gridDialectHasNoProperConstructor(clazz);
                }
                if ((gridDialect = (GridDialect)injector.newInstance(this.datastore)) instanceof BatchableGridDialect) {
                    BatchableGridDialect batchable = (BatchableGridDialect)gridDialect;
                    gridDialect = new BatchOperationsDelegator(batchable);
                }
                log.useGridDialect(gridDialect.getClass().getName());
                if (GridDialectLogger.activationNeeded()) {
                    gridDialect = new GridDialectLogger(gridDialect);
                    log.info("Grid dialect logs are active");
                } else {
                    log.info("Grid dialect logs are disabled");
                }
                return gridDialect;
            }
            catch (Exception e) {
                throw log.cannotInstantiateGridDialect(clazz, e);
            }
        }
    }
}

