/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import org.hibernate.dialect.Dialect;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.ogm.dialect.identitycolumnaware.IdentityColumnAwareGridDialect;
import org.hibernate.ogm.dialect.impl.GridDialects;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.id.impl.OgmIdentityGenerator;
import org.hibernate.ogm.id.impl.OgmSequenceGenerator;
import org.hibernate.ogm.id.impl.OgmTableGenerator;

public class OgmDialect
extends Dialect {
    private final GridDialect gridDialect;

    public OgmDialect(GridDialect gridDialect) {
        this.gridDialect = gridDialect;
    }

    public GridDialect getGridDialect() {
        return this.gridDialect;
    }

    public Class<? extends IdentifierGenerator> getNativeIdentifierGeneratorClass() {
        if (GridDialects.hasFacet(this.gridDialect, IdentityColumnAwareGridDialect.class)) {
            return OgmIdentityGenerator.class;
        }
        if (this.gridDialect.supportsSequences()) {
            return OgmSequenceGenerator.class;
        }
        return OgmTableGenerator.class;
    }
}

