/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.id.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.id.impl.OgmGeneratorBase;
import org.hibernate.ogm.id.impl.OgmTableGenerator;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.Type;

public class OgmSequenceGenerator
extends OgmGeneratorBase {
    private static final Log log = LoggerFactory.make();
    private Type type;
    private Properties params;
    private String sequenceName;
    private IdSourceKeyMetadata generatorKeyMetadata;
    private IdSourceKeyAndKeyMetadataProvider delegate;

    @Override
    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        super.configure(type, params, dialect);
        this.type = type;
        this.params = params;
        this.sequenceName = this.determineSequenceName(params, dialect);
        this.generatorKeyMetadata = IdSourceKeyMetadata.forSequence(this.sequenceName);
        this.delegate = this.getDelegate(dialect);
    }

    @Override
    public IdSourceKeyMetadata getGeneratorKeyMetadata() {
        return this.delegate.getGeneratorKeyMetadata();
    }

    @Override
    protected IdSourceKey getGeneratorKey(SessionImplementor session) {
        return this.delegate.getGeneratorKey(session);
    }

    private String determineSequenceName(Properties params, Dialect dialect) {
        String sequencePerEntitySuffix = ConfigurationHelper.getString((String)"sequence_per_entity_suffix", (Map)params, (String)"_SEQ");
        String sequenceName = ConfigurationHelper.getBoolean((String)"prefer_sequence_per_entity", (Map)params, (boolean)false) ? params.getProperty("jpa_entity_name") + sequencePerEntitySuffix : "hibernate_sequence";
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        if ((sequenceName = ConfigurationHelper.getString((String)"sequence_name", (Map)params, (String)sequenceName)).indexOf(46) < 0) {
            String catalogName;
            sequenceName = normalizer.normalizeIdentifierQuoting(sequenceName);
            String schemaName = params.getProperty("schema");
            if (schemaName != null) {
                log.schemaOptionNotSupportedForSequenceGenerator(schemaName);
            }
            if ((catalogName = params.getProperty("catalog")) != null) {
                log.catalogOptionNotSupportedForSequenceGenerator(catalogName);
            }
        }
        return sequenceName;
    }

    private IdSourceKeyAndKeyMetadataProvider getDelegate(Dialect dialect) {
        GridDialect gridDialect = super.getGridDialect();
        if (gridDialect.supportsSequences()) {
            return new SequenceKeyAndMetadataProvider(this.generatorKeyMetadata);
        }
        log.dialectDoesNotSupportSequences(gridDialect.getClass().getName());
        OgmTableGenerator tableGenerator = new OgmTableGenerator();
        Properties newParams = new Properties();
        newParams.putAll((Map<?, ?>)this.params);
        newParams.put("segment_value", this.sequenceName);
        tableGenerator.configure(this.type, newParams, dialect);
        return new TableKeyAndMetadataProvider(tableGenerator);
    }

    private static class SequenceKeyAndMetadataProvider
    implements IdSourceKeyAndKeyMetadataProvider {
        private final IdSourceKey idSourceKey;

        private SequenceKeyAndMetadataProvider(IdSourceKeyMetadata idSourceKeyMetadata) {
            this.idSourceKey = IdSourceKey.forSequence(idSourceKeyMetadata);
        }

        @Override
        public IdSourceKeyMetadata getGeneratorKeyMetadata() {
            return this.idSourceKey.getMetadata();
        }

        @Override
        public IdSourceKey getGeneratorKey(SessionImplementor session) {
            return this.idSourceKey;
        }
    }

    private static class TableKeyAndMetadataProvider
    implements IdSourceKeyAndKeyMetadataProvider {
        private final OgmTableGenerator delegate;

        public TableKeyAndMetadataProvider(OgmTableGenerator delegate) {
            this.delegate = delegate;
        }

        @Override
        public IdSourceKeyMetadata getGeneratorKeyMetadata() {
            return this.delegate.getGeneratorKeyMetadata();
        }

        @Override
        public IdSourceKey getGeneratorKey(SessionImplementor session) {
            return this.delegate.getGeneratorKey(session);
        }
    }

    private static interface IdSourceKeyAndKeyMetadataProvider {
        public IdSourceKeyMetadata getGeneratorKeyMetadata();

        public IdSourceKey getGeneratorKey(SessionImplementor var1);
    }
}

