/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.id.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.MappingException;
import org.hibernate.cfg.ObjectNameNormalizer;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.Configurable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.internal.util.config.ConfigurationHelper;
import org.hibernate.ogm.id.impl.OgmGeneratorBase;
import org.hibernate.ogm.model.key.spi.IdSourceKey;
import org.hibernate.ogm.model.key.spi.IdSourceKeyMetadata;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.impl.StringType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.LongType;
import org.hibernate.type.Type;

public class OgmTableGenerator
extends OgmGeneratorBase
implements Configurable {
    public static final String CONFIG_PREFER_SEGMENT_PER_ENTITY = "prefer_entity_table_as_segment_value";
    public static final String TABLE_PARAM = "table_name";
    public static final String DEF_TABLE = "hibernate_sequences";
    public static final String VALUE_COLUMN_PARAM = "value_column_name";
    public static final String DEF_VALUE_COLUMN = "next_val";
    public static final String SEGMENT_COLUMN_PARAM = "segment_column_name";
    public static final String DEF_SEGMENT_COLUMN = "sequence_name";
    public static final String SEGMENT_VALUE_PARAM = "segment_value";
    public static final String DEF_SEGMENT_VALUE = "default";
    private static final Log log = LoggerFactory.make();
    private Type identifierType;
    private volatile GridType identifierValueGridType;
    private String tableName;
    private String segmentColumnName;
    private String segmentValue;
    private String valueColumnName;
    private final GridType segmentGridType = StringType.INSTANCE;
    private IdSourceKeyMetadata generatorKeyMetadata;

    @Override
    public IdSourceKeyMetadata getGeneratorKeyMetadata() {
        return this.generatorKeyMetadata;
    }

    public final Type getIdentifierType() {
        return this.identifierType;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final String getSegmentColumnName() {
        return this.segmentColumnName;
    }

    @Override
    public void configure(Type type, Properties params, Dialect dialect) throws MappingException {
        super.configure(type, params, dialect);
        this.identifierType = type;
        this.tableName = this.determineGeneratorTableName(params, dialect);
        this.segmentColumnName = this.determineSegmentColumnName(params, dialect);
        this.valueColumnName = this.determineValueColumnName(params, dialect);
        this.segmentValue = this.determineSegmentValue(params);
        this.generatorKeyMetadata = IdSourceKeyMetadata.forTable(this.tableName, this.segmentColumnName, this.valueColumnName);
    }

    protected String determineGeneratorTableName(Properties params, Dialect dialect) {
        boolean isGivenNameUnqualified;
        String name = ConfigurationHelper.getString((String)TABLE_PARAM, (Map)params, (String)DEF_TABLE);
        boolean bl = isGivenNameUnqualified = name.indexOf(46) < 0;
        if (isGivenNameUnqualified) {
            String catalogName;
            ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
            name = normalizer.normalizeIdentifierQuoting(name);
            String schemaName = normalizer.normalizeIdentifierQuoting(params.getProperty("schema"));
            if (schemaName != null) {
                log.schemaOptionNotSupportedForTableGenerator(schemaName);
            }
            if ((catalogName = normalizer.normalizeIdentifierQuoting(params.getProperty("catalog"))) != null) {
                log.catalogOptionNotSupportedForTableGenerator(catalogName);
            }
        }
        return name;
    }

    protected String determineSegmentColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = ConfigurationHelper.getString((String)SEGMENT_COLUMN_PARAM, (Map)params, (String)DEF_SEGMENT_COLUMN);
        return dialect.quote(normalizer.normalizeIdentifierQuoting(name));
    }

    protected String determineValueColumnName(Properties params, Dialect dialect) {
        ObjectNameNormalizer normalizer = (ObjectNameNormalizer)params.get("identifier_normalizer");
        String name = ConfigurationHelper.getString((String)VALUE_COLUMN_PARAM, (Map)params, (String)DEF_VALUE_COLUMN);
        return dialect.quote(normalizer.normalizeIdentifierQuoting(name));
    }

    protected String determineSegmentValue(Properties params) {
        String segmentValue = params.getProperty(SEGMENT_VALUE_PARAM);
        if (StringHelper.isEmpty((String)segmentValue)) {
            segmentValue = this.determineDefaultSegmentValue(params);
        }
        return segmentValue;
    }

    protected String determineDefaultSegmentValue(Properties params) {
        boolean preferSegmentPerEntity = ConfigurationHelper.getBoolean((String)CONFIG_PREFER_SEGMENT_PER_ENTITY, (Map)params, (boolean)false);
        String defaultToUse = preferSegmentPerEntity ? params.getProperty("target_table") : DEF_SEGMENT_VALUE;
        log.infof("explicit segment value for id generator [%1$s.%2$s] suggested; using default [%3$s]", this.tableName, this.segmentColumnName, defaultToUse);
        return defaultToUse;
    }

    @Override
    protected IdSourceKey getGeneratorKey(SessionImplementor session) {
        this.defineGridTypes(session);
        String segmentName = (String)this.nullSafeSet(this.segmentGridType, this.segmentValue, this.segmentColumnName, session);
        return IdSourceKey.forTable(this.generatorKeyMetadata, segmentName);
    }

    private Object nullSafeSet(GridType type, Object value, String columnName, SessionImplementor session) {
        Tuple tuple = new Tuple();
        type.nullSafeSet(tuple, value, new String[]{columnName}, session);
        return tuple.get(columnName);
    }

    private void defineGridTypes(SessionImplementor session) {
        if (this.identifierValueGridType == null) {
            ServiceRegistryImplementor registry = session.getFactory().getServiceRegistry();
            this.identifierValueGridType = ((TypeTranslator)registry.getService(TypeTranslator.class)).getType((Type)new LongType());
        }
    }
}

