/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;

public class AssociatedEntityKeyMetadata {
    private final String[] associationKeyColumns;
    private final EntityKeyMetadata entityKeyMetadata;

    public AssociatedEntityKeyMetadata(String[] associationKeyColumns, EntityKeyMetadata entityKeyMetadata) {
        this.associationKeyColumns = associationKeyColumns;
        this.entityKeyMetadata = entityKeyMetadata;
    }

    public EntityKeyMetadata getEntityKeyMetadata() {
        return this.entityKeyMetadata;
    }

    public String getCorrespondingEntityKeyColumn(String associationKeyColumn) {
        int i = 0;
        for (String column : this.associationKeyColumns) {
            if (associationKeyColumn.equals(column)) {
                return this.entityKeyMetadata.getColumnNames()[i];
            }
            ++i;
        }
        return null;
    }

    public String[] getAssociationKeyColumns() {
        return this.associationKeyColumns;
    }

    public String toString() {
        return "AssociatedEntityKeyMetadata [associationKeyColumns=" + Arrays.toString(this.associationKeyColumns) + ", entityKeyMetadata=" + this.entityKeyMetadata + "]";
    }
}

