/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.spi.AssociationKind;

public class AssociationKeyMetadata {
    private final String table;
    private final String[] columnNames;
    private final int hashCode;
    private final String[] rowKeyColumnNames;
    private final String[] rowKeyIndexColumnNames;
    private final boolean isInverse;
    private final AssociatedEntityKeyMetadata associatedEntityKeyMetadata;
    private final String collectionRole;
    private final AssociationKind associationKind;

    public AssociationKeyMetadata(String table, String[] columnNames, String[] rowKeyColumnNames, String[] rowKeyIndexColumnNames, AssociatedEntityKeyMetadata associatedEntityKeyMetadata, boolean isInverse, String collectionRole, AssociationKind associationKind) {
        this.table = table;
        this.columnNames = columnNames;
        this.rowKeyColumnNames = rowKeyColumnNames;
        this.rowKeyIndexColumnNames = rowKeyIndexColumnNames;
        this.isInverse = isInverse;
        this.associatedEntityKeyMetadata = associatedEntityKeyMetadata;
        this.collectionRole = collectionRole;
        this.associationKind = associationKind;
        this.hashCode = table.hashCode();
    }

    public String getTable() {
        return this.table;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getRowKeyColumnNames() {
        return this.rowKeyColumnNames;
    }

    public String[] getRowKeyIndexColumnNames() {
        return this.rowKeyIndexColumnNames;
    }

    public AssociatedEntityKeyMetadata getAssociatedEntityKeyMetadata() {
        return this.associatedEntityKeyMetadata;
    }

    public String[] getColumnsWithoutKeyColumns(Iterable<String> candidates) {
        ArrayList<String> nonKeyColumns = new ArrayList<String>();
        for (String column : candidates) {
            if (this.isKeyColumn(column)) continue;
            nonKeyColumns.add(column);
        }
        return nonKeyColumns.toArray(new String[nonKeyColumns.size()]);
    }

    public String getSingleRowKeyColumnNotContainedInAssociationKey() {
        String nonKeyColumn = null;
        for (String column : this.getRowKeyColumnNames()) {
            if (this.isKeyColumn(column)) continue;
            if (nonKeyColumn != null) {
                return null;
            }
            nonKeyColumn = column;
        }
        return nonKeyColumn;
    }

    public boolean isKeyColumn(String columnName) {
        for (String keyColumName : this.getColumnNames()) {
            if (!keyColumName.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public AssociationKind getAssociationKind() {
        return this.associationKind;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || AssociationKeyMetadata.class != o.getClass()) {
            return false;
        }
        AssociationKeyMetadata that = (AssociationKeyMetadata)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        return Arrays.equals(this.columnNames, that.columnNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "AssociationKeyMetadata [table=" + this.table + ", columnNames=" + Arrays.toString(this.columnNames) + ", isInverse=" + this.isInverse + ", collectionRole=" + this.collectionRole + ", associationKind=" + (Object)((Object)this.associationKind) + ", rowKeyColumnNames=" + Arrays.toString(this.rowKeyColumnNames) + ", rowKeyIndexColumnNames=" + Arrays.toString(this.rowKeyIndexColumnNames) + ", associatedEntityKeyMetadata=" + this.associatedEntityKeyMetadata + "]";
    }
}

