/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.util.Arrays;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.persister.impl.OgmCollectionPersister;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.persister.entity.Loadable;
import org.hibernate.type.AssociationType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class BiDirectionalAssociationHelper {
    private BiDirectionalAssociationHelper() {
    }

    public static AssociationKeyMetadata getInverseAssociationKeyMetadata(OgmEntityPersister mainSidePersister, int propertyIndex) {
        Type propertyType = mainSidePersister.getPropertyTypes()[propertyIndex];
        SessionFactoryImplementor factory = mainSidePersister.getFactory();
        if (!propertyType.isAssociationType()) {
            return null;
        }
        Object mainSideJoinable = ((AssociationType)propertyType).getAssociatedJoinable(factory);
        OgmEntityPersister inverseSidePersister = null;
        if (mainSideJoinable.isCollection()) {
            inverseSidePersister = (OgmEntityPersister)((OgmCollectionPersister)mainSideJoinable).getElementPersister();
        } else {
            inverseSidePersister = (OgmEntityPersister)((Object)mainSideJoinable);
            mainSideJoinable = mainSidePersister;
        }
        String mainSideProperty = mainSidePersister.getPropertyNames()[propertyIndex];
        AssociationKeyMetadata inverseOneToOneMetadata = mainSidePersister.getInverseOneToOneAssociationKeyMetadata(mainSideProperty);
        if (inverseOneToOneMetadata != null) {
            return inverseOneToOneMetadata;
        }
        for (String candidateProperty : inverseSidePersister.getPropertyNames()) {
            OgmCollectionPersister inverseCollectionPersister;
            Type type = inverseSidePersister.getPropertyType(candidateProperty);
            if (!type.isCollectionType() || !BiDirectionalAssociationHelper.isCollectionMatching(mainSideJoinable, inverseCollectionPersister = BiDirectionalAssociationHelper.getPersister(factory, (CollectionType)type))) continue;
            return inverseCollectionPersister.getAssociationKeyMetadata();
        }
        return null;
    }

    public static AssociationKeyMetadata getInverseAssociationKeyMetadata(OgmCollectionPersister mainSidePersister) {
        if (mainSidePersister.isInverse() || !mainSidePersister.isManyToMany() || !mainSidePersister.getElementType().isEntityType()) {
            return null;
        }
        EntityPersister inverseSidePersister = mainSidePersister.getElementPersister();
        for (Type type : inverseSidePersister.getPropertyTypes()) {
            OgmCollectionPersister inverseCollectionPersister;
            if (!type.isCollectionType() || !BiDirectionalAssociationHelper.isCollectionMatching((Joinable)mainSidePersister, inverseCollectionPersister = BiDirectionalAssociationHelper.getPersister(mainSidePersister.getFactory(), (CollectionType)type))) continue;
            return inverseCollectionPersister.getAssociationKeyMetadata();
        }
        return null;
    }

    public static String getMainSidePropertyName(OgmCollectionPersister collectionPersister) {
        if (!collectionPersister.isInverse()) {
            return collectionPersister.getUnqualifiedRole();
        }
        Loadable mainSidePersister = (Loadable)collectionPersister.getElementPersister();
        for (int i = 0; i < mainSidePersister.getPropertyNames().length; ++i) {
            OgmCollectionPersister mainSideCollectionPersister;
            String candidateProperty = mainSidePersister.getPropertyNames()[i];
            Type type = mainSidePersister.getPropertyType(candidateProperty);
            if (!(type.isEntityType() ? Arrays.equals(collectionPersister.getKeyColumnNames(), mainSidePersister.getPropertyColumnNames(i)) : type.isCollectionType() && BiDirectionalAssociationHelper.isCollectionMatching((Joinable)(mainSideCollectionPersister = BiDirectionalAssociationHelper.getPersister(collectionPersister.getFactory(), (CollectionType)type)), collectionPersister))) continue;
            return candidateProperty;
        }
        throw new HibernateException("Couldn't determine main side role for collection " + collectionPersister.getRole());
    }

    private static boolean isCollectionMatching(Joinable mainSideJoinable, OgmCollectionPersister inverseSidePersister) {
        boolean isSameTable = mainSideJoinable.getTableName().equals(inverseSidePersister.getTableName());
        if (!isSameTable) {
            return false;
        }
        return Arrays.equals(mainSideJoinable.getKeyColumnNames(), inverseSidePersister.getElementColumnNames());
    }

    private static OgmCollectionPersister getPersister(SessionFactoryImplementor factory, CollectionType type) {
        return (OgmCollectionPersister)factory.getCollectionPersister(type.getRole());
    }
}

