/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.io.Serializable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.tuple.entity.EntityMetamodel;

class EntityDehydrator {
    private static final Log log = LoggerFactory.make();
    private final OgmEntityPersister persister;
    private Tuple resultset;
    private Object[] fields;
    private boolean[] includeProperties;
    private int tableIndex;
    private Serializable id;
    private SessionImplementor session;

    public EntityDehydrator(OgmEntityPersister persister) {
        this.persister = persister;
    }

    public EntityDehydrator resultset(Tuple resultset) {
        this.resultset = resultset;
        return this;
    }

    public EntityDehydrator fields(Object[] fields) {
        this.fields = fields;
        return this;
    }

    public EntityDehydrator includeProperties(boolean[] includeProperties) {
        this.includeProperties = includeProperties;
        return this;
    }

    public EntityDehydrator tableIndex(int tableIndex) {
        this.tableIndex = tableIndex;
        return this;
    }

    public EntityDehydrator id(Serializable id) {
        this.id = id;
        return this;
    }

    public EntityDehydrator session(SessionImplementor session) {
        this.session = session;
        return this;
    }

    public void dehydrate() {
        if (log.isTraceEnabled()) {
            log.trace("Dehydrating entity: " + MessageHelper.infoString((EntityPersister)this.persister, (Object)this.id, (SessionFactoryImplementor)this.persister.getFactory()));
        }
        EntityMetamodel entityMetamodel = this.persister.getEntityMetamodel();
        for (int propertyIndex = 0; propertyIndex < entityMetamodel.getPropertySpan(); ++propertyIndex) {
            if (!this.persister.isPropertyOfTable(propertyIndex, this.tableIndex) || !this.includeProperties[propertyIndex]) continue;
            this.persister.getGridPropertyTypes()[propertyIndex].nullSafeSet(this.resultset, this.fields[propertyIndex], this.persister.getPropertyColumnNames(propertyIndex), this.persister.getPropertyColumnInsertable()[propertyIndex], this.session);
        }
    }
}

