/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.query.impl;

import java.io.Serializable;
import java.util.Set;
import org.hibernate.engine.query.spi.NativeQueryInterpreter;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.custom.CustomQuery;
import org.hibernate.ogm.dialect.queryable.spi.ParameterMetadataBuilder;
import org.hibernate.ogm.dialect.queryable.spi.QueryableGridDialect;
import org.hibernate.ogm.loader.nativeloader.impl.BackendCustomQuery;
import org.hibernate.ogm.query.impl.NativeNoSqlQueryPlan;

public class NativeNoSqlQueryInterpreter
implements NativeQueryInterpreter {
    private final QueryableGridDialect<?> gridDialect;
    private final ParameterMetadataBuilder builder;

    public NativeNoSqlQueryInterpreter(QueryableGridDialect<?> gridDialect) {
        this.gridDialect = gridDialect;
        this.builder = gridDialect.getParameterMetadataBuilder();
    }

    public ParameterMetadata getParameterMetadata(String nativeQuery) {
        return this.builder.buildParameterMetadata(nativeQuery);
    }

    public NativeSQLQueryPlan createQueryPlan(NativeSQLQuerySpecification specification, SessionFactoryImplementor sessionFactory) {
        CustomQuery customQuery = this.getCustomQuery(this.gridDialect, specification, sessionFactory);
        return new NativeNoSqlQueryPlan(specification.getQueryString(), customQuery);
    }

    private <T extends Serializable> CustomQuery getCustomQuery(QueryableGridDialect<T> gridDialect, NativeSQLQuerySpecification specification, SessionFactoryImplementor sessionFactory) {
        T query = gridDialect.parseNativeQuery(specification.getQueryString());
        Set querySpaces = specification.getQuerySpaces();
        return new BackendCustomQuery<T>(specification.getQueryString(), query, specification.getQueryReturns(), querySpaces, sessionFactory);
    }
}

