/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.primitive.hopscotch;

import java.lang.reflect.Field;
import org.neo4j.collection.primitive.hopscotch.PowerOfTwoQuantizedTable;
import sun.misc.Unsafe;

public abstract class UnsafeTable<VALUE>
extends PowerOfTwoQuantizedTable<VALUE> {
    protected static final Unsafe unsafe = UnsafeTable.getUnsafe();
    private final int bytesPerKey;
    private final int bytesPerEntry;
    private final long dataSize;
    private final long address;
    protected final VALUE valueMarker;

    protected UnsafeTable(int capacity, int bytesPerKey, VALUE valueMarker) {
        super(capacity, 32);
        this.bytesPerKey = bytesPerKey;
        this.bytesPerEntry = 4 + bytesPerKey;
        this.valueMarker = valueMarker;
        this.dataSize = (long)this.capacity * (long)this.bytesPerEntry;
        System.out.println("allocate memory " + this.dataSize);
        this.address = unsafe.allocateMemory(this.dataSize);
        this.clear();
    }

    @Override
    public void clear() {
        super.clear();
        unsafe.setMemory(this.address, this.dataSize, (byte)-1);
    }

    @Override
    public long key(int index) {
        return this.internalKey(this.keyAddress(index));
    }

    protected abstract long internalKey(long var1);

    @Override
    public VALUE value(int index) {
        return this.valueMarker;
    }

    @Override
    public void put(int index, long key, VALUE value) {
        this.internalPut(this.keyAddress(index), key, value);
        ++this.size;
    }

    protected abstract void internalPut(long var1, long var3, VALUE var5);

    @Override
    public VALUE putValue(int index, VALUE value) {
        return value;
    }

    @Override
    public long move(int fromIndex, int toIndex) {
        long adr = this.keyAddress(fromIndex);
        long key = this.internalKey(adr);
        VALUE value = this.internalRemove(adr);
        this.internalPut(this.keyAddress(toIndex), key, value);
        return key;
    }

    @Override
    public VALUE remove(int index) {
        VALUE value = this.internalRemove(this.keyAddress(index));
        --this.size;
        return value;
    }

    protected VALUE internalRemove(long keyAddress) {
        unsafe.setMemory(keyAddress, this.bytesPerKey, (byte)-1);
        return this.valueMarker;
    }

    @Override
    public long hopBits(int index) {
        return ((long)unsafe.getInt(this.hopBitsAddress(index)) | 0xFFFFFFFF00000000L) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void putHopBit(int index, int hd) {
        long adr = this.hopBitsAddress(index);
        int hopBits = unsafe.getInt(adr);
        unsafe.putInt(adr, hopBits &= ~(1 << hd));
    }

    @Override
    public void moveHopBit(int index, int hd, int delta) {
        long adr = this.hopBitsAddress(index);
        int hopBits = unsafe.getInt(adr);
        unsafe.putInt(adr, hopBits ^= 1 << hd | 1 << hd + delta);
    }

    protected long keyAddress(int index) {
        return this.address + (long)(index * this.bytesPerEntry) + 4L;
    }

    protected long hopBitsAddress(int index) {
        return this.address + (long)(index * this.bytesPerEntry);
    }

    @Override
    public void removeHopBit(int index, int hd) {
        long adr = this.hopBitsAddress(index);
        int hopBits = unsafe.getInt(adr);
        unsafe.putInt(adr, hopBits |= 1 << hd);
    }

    private static Unsafe getUnsafe() {
        try {
            Field singleoneInstanceField = Unsafe.class.getDeclaredField("theUnsafe");
            singleoneInstanceField.setAccessible(true);
            return (Unsafe)singleoneInstanceField.get(null);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    @Override
    public void close() {
        unsafe.freeMemory(this.address);
    }
}

