/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;

public class MultipleBackupDeletionPolicy
extends SnapshotDeletionPolicy {
    static final String SNAPSHOT_ID = "backup";
    private IndexCommit snapshot;
    private int snapshotUsers;

    public MultipleBackupDeletionPolicy() {
        super((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy());
    }

    public synchronized IndexCommit snapshot(String id) throws IOException {
        if (this.snapshotUsers == 0) {
            this.snapshot = super.snapshot(id);
        }
        ++this.snapshotUsers;
        return this.snapshot;
    }

    public synchronized void release(String id) throws IOException {
        if (--this.snapshotUsers > 0) {
            return;
        }
        super.release(id);
        this.snapshot = null;
        if (this.snapshotUsers < 0) {
            this.snapshotUsers = 0;
            throw new IllegalStateException("Cannot release snapshot, no snapshot held");
        }
    }
}

