/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.helpers.progress;

import org.neo4j.helpers.progress.Aggregator;
import org.neo4j.helpers.progress.Indicator;

public abstract class ProgressListener {
    public static final ProgressListener NONE = new ProgressListener(){

        @Override
        public void started() {
        }

        @Override
        public void set(long progress) {
        }

        @Override
        public void add(long progress) {
        }

        @Override
        public void done() {
        }

        @Override
        public void failed(Throwable e) {
        }
    };

    public abstract void started();

    public abstract void set(long var1);

    public abstract void add(long var1);

    public abstract void done();

    public abstract void failed(Throwable var1);

    private ProgressListener() {
    }

    static final class MultiPartProgressListener
    extends ProgressListener {
        private final Aggregator aggregator;
        final String part;
        boolean started = false;
        private long value = 0L;
        private long lastReported = 0L;
        final long totalCount;

        MultiPartProgressListener(Aggregator aggregator, String part, long totalCount) {
            this.aggregator = aggregator;
            this.part = part;
            this.totalCount = totalCount;
        }

        @Override
        public void started() {
            if (!this.started) {
                this.aggregator.start(this);
                this.started = true;
            }
        }

        @Override
        public void set(long progress) {
            this.value = progress;
            this.update(this.value);
        }

        @Override
        public void add(long progress) {
            this.update(this.value += progress);
        }

        @Override
        public void done() {
            this.set(this.totalCount);
            this.aggregator.complete(this);
        }

        @Override
        public void failed(Throwable e) {
            this.aggregator.signalFailure(this.part, e);
        }

        private void update(long progress) {
            this.started();
            if (progress > this.lastReported) {
                this.aggregator.update(progress - this.lastReported);
                this.lastReported = progress;
            }
        }

        static enum State {
            INIT,
            LIVE;

        }
    }

    static final class OpenEndedProgressListener
    extends SinglePartProgressListener {
        private int lastReported = 0;

        OpenEndedProgressListener(Indicator indicator) {
            super(indicator, 0L);
        }

        @Override
        public void done() {
            this.indicator.completeProcess();
        }

        @Override
        void update(long progress) {
            this.started();
            int current = (int)(progress / (long)this.indicator.reportResolution());
            if (current > this.lastReported) {
                this.indicator.progress(this.lastReported, current);
                this.lastReported = current;
            }
        }
    }

    static class SinglePartProgressListener
    extends ProgressListener {
        final Indicator indicator;
        private final long totalCount;
        private long value = 0L;
        private int lastReported = 0;
        private boolean stared = false;

        SinglePartProgressListener(Indicator indicator, long totalCount) {
            this.indicator = indicator;
            this.totalCount = totalCount;
        }

        @Override
        public void started() {
            if (!this.stared) {
                this.stared = true;
                this.indicator.startProcess(this.totalCount);
            }
        }

        @Override
        public void set(long progress) {
            this.value = progress;
            this.update(this.value);
        }

        @Override
        public void add(long progress) {
            this.update(this.value += progress);
        }

        @Override
        public void done() {
            this.set(this.totalCount);
            this.indicator.completeProcess();
        }

        @Override
        public void failed(Throwable e) {
            this.indicator.failure(e);
        }

        void update(long progress) {
            int current;
            this.started();
            int n = current = this.totalCount == 0L ? 0 : (int)(progress * (long)this.indicator.reportResolution() / this.totalCount);
            if (current > this.lastReported) {
                this.indicator.progress(this.lastReported, current);
                this.lastReported = current;
            }
        }
    }
}

