/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.StoreFileType;

public enum StoreFile19 {
    NODE_STORE("NodeStore", ".nodestore.db"),
    PROPERTY_STORE("PropertyStore", ".propertystore.db"),
    PROPERTY_ARRAY_STORE("ArrayPropertyStore", ".propertystore.db.arrays"),
    PROPERTY_STRING_STORE("StringPropertyStore", ".propertystore.db.strings"),
    PROPERTY_KEY_TOKEN_STORE("PropertyIndexStore", ".propertystore.db.index"),
    PROPERTY_KEY_TOKEN_NAMES_STORE("StringPropertyStore", ".propertystore.db.index.keys"),
    RELATIONSHIP_STORE("RelationshipStore", ".relationshipstore.db"),
    RELATIONSHIP_TYPE_TOKEN_STORE("RelationshipTypeStore", ".relationshiptypestore.db"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("StringPropertyStore", ".relationshiptypestore.db.names"),
    NEO_STORE("NeoStore", "");

    private final String typeDescriptor;
    private final String storeFileNamePart;
    private final boolean existsInBoth;

    private StoreFile19(String typeDescriptor, String storeFileNamePart) {
        this(typeDescriptor, storeFileNamePart, true);
    }

    private StoreFile19(String typeDescriptor, String storeFileNamePart, boolean existsInBoth) {
        this.typeDescriptor = typeDescriptor;
        this.storeFileNamePart = storeFileNamePart;
        this.existsInBoth = existsInBoth;
    }

    public String legacyVersion() {
        return this.typeDescriptor + " " + "v0.A.0";
    }

    public String fileName(StoreFileType type) {
        return type.augment("neostore" + this.storeFileNamePart);
    }

    public String storeFileName() {
        return this.fileName(StoreFileType.STORE);
    }

    public static Iterable<StoreFile19> legacyStoreFiles() {
        Predicate<StoreFile19> predicate = new Predicate<StoreFile19>(){

            @Override
            public boolean accept(StoreFile19 item) {
                return item.existsInBoth;
            }
        };
        Iterable<StoreFile19> storeFiles = StoreFile19.currentStoreFiles();
        return Iterables.filter(predicate, storeFiles);
    }

    public static Iterable<StoreFile19> currentStoreFiles() {
        return Iterables.iterable(StoreFile19.values());
    }

    public static void move(FileSystemAbstraction fs, File fromDirectory, File toDirectory, Iterable<StoreFile19> files, boolean allowSkipNonExistentFiles, boolean allowOverwriteTarget, StoreFileType ... types) throws IOException {
        for (StoreFile19 storeFile : files) {
            for (StoreFileType type : types) {
                StoreFile19.moveFile(fs, storeFile.fileName(type), fromDirectory, toDirectory, allowSkipNonExistentFiles, allowOverwriteTarget);
            }
        }
    }

    static void moveFile(FileSystemAbstraction fs, String fileName, File fromDirectory, File toDirectory, boolean allowSkipNonExistentFiles, boolean allowOverwriteTarget) throws IOException {
        File sourceFile = new File(fromDirectory, fileName);
        if (allowSkipNonExistentFiles && !fs.fileExists(sourceFile)) {
            return;
        }
        File toFile = new File(toDirectory, fileName);
        if (allowOverwriteTarget && fs.fileExists(toFile)) {
            fs.deleteFile(toFile);
        }
        fs.moveToDirectory(sourceFile, toDirectory);
    }
}

