/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Triplet;
import org.neo4j.kernel.impl.storemigration.StoreFile19;
import org.neo4j.kernel.impl.storemigration.StoreFile20;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.StoreVersionCheck;

public class UpgradableDatabase {
    private final StoreVersionCheck storeVersionCheck;

    public UpgradableDatabase(StoreVersionCheck storeVersionCheck) {
        this.storeVersionCheck = storeVersionCheck;
    }

    public boolean storeFilesUpgradeable(File storeDirectory) {
        try {
            this.checkUpgradeable(storeDirectory);
            return true;
        }
        catch (StoreUpgrader.UnableToUpgradeException e) {
            return false;
        }
    }

    public String checkUpgradeable(File storeDirectory) {
        Triplet<StoreVersionCheck.Outcome, String, String> outcome = this.checkUpgradeableFor19(storeDirectory);
        if (outcome.first().isSuccessful()) {
            return "v0.A.0";
        }
        outcome = this.checkUpgradeableFor20(storeDirectory);
        if (!outcome.first().isSuccessful()) {
            String foundVersion = outcome.second();
            String storeFileName = outcome.third();
            switch (outcome.first()) {
                case missingStoreFile: {
                    throw new StoreUpgrader.UpgradeMissingStoreFilesException(storeFileName);
                }
                case storeVersionNotFound: {
                    throw new StoreUpgrader.UpgradingStoreVersionNotFoundException(storeFileName);
                }
                case unexpectedUpgradingStoreVersion: {
                    throw new StoreUpgrader.UnexpectedUpgradingStoreVersionException(storeFileName, "v0.A.1", foundVersion);
                }
            }
            throw new IllegalArgumentException(outcome.first().name());
        }
        return "v0.A.1";
    }

    private Triplet<StoreVersionCheck.Outcome, String, String> checkUpgradeableFor20(File storeDirectory) {
        Triplet<StoreVersionCheck.Outcome, String, String> outcome = null;
        for (StoreFile20 store : StoreFile20.legacyStoreFiles()) {
            String expectedVersion = store.legacyVersion();
            File storeFile = new File(storeDirectory, store.storeFileName());
            Pair<StoreVersionCheck.Outcome, String> check = this.storeVersionCheck.hasVersion(storeFile, expectedVersion);
            outcome = Triplet.of(check.first(), check.other(), storeFile.getName());
            if (check.first().isSuccessful()) continue;
            break;
        }
        return outcome;
    }

    private Triplet<StoreVersionCheck.Outcome, String, String> checkUpgradeableFor19(File storeDirectory) {
        Triplet<StoreVersionCheck.Outcome, String, String> outcome = null;
        for (StoreFile19 store : StoreFile19.legacyStoreFiles()) {
            String expectedVersion = store.legacyVersion();
            File storeFile = new File(storeDirectory, store.storeFileName());
            Pair<StoreVersionCheck.Outcome, String> check = this.storeVersionCheck.hasVersion(storeFile, expectedVersion);
            outcome = Triplet.of(check.first(), check.other(), storeFile.getName());
            if (check.first().isSuccessful()) continue;
            break;
        }
        return outcome;
    }
}

