/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.Iterator;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.AddIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyConstrainedException;
import org.neo4j.kernel.api.exceptions.schema.AlreadyIndexedException;
import org.neo4j.kernel.api.exceptions.schema.ConstraintValidationKernelException;
import org.neo4j.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropConstraintFailureException;
import org.neo4j.kernel.api.exceptions.schema.DropIndexFailureException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.operations.EntityWriteOperations;
import org.neo4j.kernel.impl.api.operations.LockOperations;
import org.neo4j.kernel.impl.api.operations.SchemaReadOperations;
import org.neo4j.kernel.impl.api.operations.SchemaStateOperations;
import org.neo4j.kernel.impl.api.operations.SchemaWriteOperations;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.ResourceTypes;
import org.neo4j.kernel.impl.nioneo.store.SchemaStorage;

public class LockingStatementOperations
implements EntityWriteOperations,
SchemaReadOperations,
SchemaWriteOperations,
SchemaStateOperations,
LockOperations {
    private final EntityWriteOperations entityWriteDelegate;
    private final SchemaReadOperations schemaReadDelegate;
    private final SchemaWriteOperations schemaWriteDelegate;
    private final SchemaStateOperations schemaStateDelegate;

    public LockingStatementOperations(EntityWriteOperations entityWriteDelegate, SchemaReadOperations schemaReadDelegate, SchemaWriteOperations schemaWriteDelegate, SchemaStateOperations schemaStateDelegate) {
        this.entityWriteDelegate = entityWriteDelegate;
        this.schemaReadDelegate = schemaReadDelegate;
        this.schemaWriteDelegate = schemaWriteDelegate;
        this.schemaStateDelegate = schemaStateDelegate;
    }

    @Override
    public boolean nodeAddLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException, ConstraintValidationKernelException {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        state.locks().acquireExclusive(ResourceTypes.NODE, nodeId);
        return this.entityWriteDelegate.nodeAddLabel(state, nodeId, labelId);
    }

    @Override
    public boolean nodeRemoveLabel(KernelStatement state, long nodeId, int labelId) throws EntityNotFoundException {
        state.locks().acquireExclusive(ResourceTypes.NODE, nodeId);
        return this.entityWriteDelegate.nodeRemoveLabel(state, nodeId, labelId);
    }

    @Override
    public IndexDescriptor indexCreate(KernelStatement state, int labelId, int propertyKey) throws AddIndexFailureException, AlreadyIndexedException, AlreadyConstrainedException {
        state.locks().acquireExclusive(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaWriteDelegate.indexCreate(state, labelId, propertyKey);
    }

    @Override
    public void indexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.locks().acquireExclusive(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        this.schemaWriteDelegate.indexDrop(state, descriptor);
    }

    @Override
    public void uniqueIndexDrop(KernelStatement state, IndexDescriptor descriptor) throws DropIndexFailureException {
        state.locks().acquireExclusive(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        this.schemaWriteDelegate.uniqueIndexDrop(state, descriptor);
    }

    @Override
    public <K, V> V schemaStateGetOrCreate(KernelStatement state, K key, Function<K, V> creator) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaStateDelegate.schemaStateGetOrCreate(state, key, creator);
    }

    @Override
    public <K> boolean schemaStateContains(KernelStatement state, K key) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaStateDelegate.schemaStateContains(state, key);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(KernelStatement state, int labelId) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.indexesGetForLabel(state, labelId);
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKey) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.indexesGetForLabelAndPropertyKey(state, labelId, propertyKey);
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll(KernelStatement state) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.indexesGetAll(state);
    }

    @Override
    public InternalIndexState indexGetState(KernelStatement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.indexGetState(state, descriptor);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(KernelStatement state, IndexDescriptor index) throws SchemaRuleNotFoundException {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.indexGetOwningUniquenessConstraintId(state, index);
    }

    @Override
    public long indexGetCommittedId(KernelStatement state, IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.indexGetCommittedId(state, index, kind);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(KernelStatement state, int labelId) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.uniqueIndexesGetForLabel(state, labelId);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll(KernelStatement state) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.uniqueIndexesGetAll(state);
    }

    @Override
    public void nodeDelete(KernelStatement state, long nodeId) {
        state.locks().acquireExclusive(ResourceTypes.NODE, nodeId);
        this.entityWriteDelegate.nodeDelete(state, nodeId);
    }

    @Override
    public long nodeCreate(KernelStatement statement) {
        return this.entityWriteDelegate.nodeCreate(statement);
    }

    @Override
    public long relationshipCreate(KernelStatement state, int relationshipTypeId, long startNodeId, long endNodeId) {
        state.locks().acquireExclusive(ResourceTypes.NODE, startNodeId);
        state.locks().acquireExclusive(ResourceTypes.NODE, endNodeId);
        return this.entityWriteDelegate.relationshipCreate(state, relationshipTypeId, startNodeId, endNodeId);
    }

    @Override
    public void relationshipDelete(KernelStatement state, long relationshipId) {
        state.locks().acquireExclusive(ResourceTypes.RELATIONSHIP, relationshipId);
        this.entityWriteDelegate.relationshipDelete(state, relationshipId);
    }

    @Override
    public UniquenessConstraint uniquenessConstraintCreate(KernelStatement state, int labelId, int propertyKeyId) throws CreateConstraintFailureException, AlreadyConstrainedException, AlreadyIndexedException {
        state.locks().acquireExclusive(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaWriteDelegate.uniquenessConstraintCreate(state, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(KernelStatement state, int labelId, int propertyKeyId) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.constraintsGetForLabelAndPropertyKey(state, labelId, propertyKeyId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(KernelStatement state, int labelId) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.constraintsGetForLabel(state, labelId);
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll(KernelStatement state) {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        return this.schemaReadDelegate.constraintsGetAll(state);
    }

    @Override
    public void constraintDrop(KernelStatement state, UniquenessConstraint constraint) throws DropConstraintFailureException {
        state.locks().acquireExclusive(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        this.schemaWriteDelegate.constraintDrop(state, constraint);
    }

    @Override
    public Property nodeSetProperty(KernelStatement state, long nodeId, DefinedProperty property) throws EntityNotFoundException, ConstraintValidationKernelException {
        state.locks().acquireShared(ResourceTypes.SCHEMA, ResourceTypes.schemaResource());
        state.locks().acquireExclusive(ResourceTypes.NODE, nodeId);
        return this.entityWriteDelegate.nodeSetProperty(state, nodeId, property);
    }

    @Override
    public Property nodeRemoveProperty(KernelStatement state, long nodeId, int propertyKeyId) throws EntityNotFoundException {
        state.locks().acquireExclusive(ResourceTypes.NODE, nodeId);
        return this.entityWriteDelegate.nodeRemoveProperty(state, nodeId, propertyKeyId);
    }

    @Override
    public Property relationshipSetProperty(KernelStatement state, long relationshipId, DefinedProperty property) throws EntityNotFoundException {
        state.locks().acquireExclusive(ResourceTypes.RELATIONSHIP, relationshipId);
        return this.entityWriteDelegate.relationshipSetProperty(state, relationshipId, property);
    }

    @Override
    public Property relationshipRemoveProperty(KernelStatement state, long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        state.locks().acquireExclusive(ResourceTypes.RELATIONSHIP, relationshipId);
        return this.entityWriteDelegate.relationshipRemoveProperty(state, relationshipId, propertyKeyId);
    }

    @Override
    public Property graphSetProperty(KernelStatement state, DefinedProperty property) {
        state.locks().acquireExclusive(ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        return this.entityWriteDelegate.graphSetProperty(state, property);
    }

    @Override
    public Property graphRemoveProperty(KernelStatement state, int propertyKeyId) {
        state.locks().acquireExclusive(ResourceTypes.GRAPH_PROPS, ResourceTypes.graphPropertyResource());
        return this.entityWriteDelegate.graphRemoveProperty(state, propertyKeyId);
    }

    @Override
    public void acquireExclusive(KernelStatement state, Locks.ResourceType resourceType, long[] resourceId) {
        state.locks().acquireExclusive(resourceType, resourceId);
    }

    @Override
    public void acquireShared(KernelStatement state, Locks.ResourceType resourceType, long[] resourceId) {
        state.locks().acquireShared(resourceType, resourceId);
    }

    @Override
    public void releaseExclusive(KernelStatement state, Locks.ResourceType type, long[] resourceId) {
        state.locks().releaseExclusive(type, resourceId);
    }

    @Override
    public void releaseShared(KernelStatement state, Locks.ResourceType type, long[] resourceId) {
        state.locks().releaseShared(type, resourceId);
    }

    @Override
    public String indexGetFailure(Statement state, IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.schemaReadDelegate.indexGetFailure(state, descriptor);
    }
}

