/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;

public class DirectMappedLogBuffer
implements LogBuffer {
    static final int BUFFER_SIZE = 524288;
    private final StoreChannel fileChannel;
    private final ByteBuffer byteBuffer;
    private long bufferStartPosition;
    private final ByteCounterMonitor monitor;

    public DirectMappedLogBuffer(StoreChannel fileChannel, ByteCounterMonitor monitor) throws IOException {
        this.fileChannel = fileChannel;
        this.monitor = monitor;
        this.bufferStartPosition = fileChannel.position();
        this.byteBuffer = ByteBuffer.allocateDirect(524288);
    }

    private void ensureCapacity(int plusSize) throws IOException {
        if (524288 - this.byteBuffer.position() < plusSize) {
            this.writeOut();
        }
        assert (524288 - this.byteBuffer.position() >= plusSize) : "after writing out buffer, position is " + this.byteBuffer.position() + " and requested size is " + plusSize;
    }

    @Override
    public LogBuffer put(byte b) throws IOException {
        this.ensureCapacity(1);
        this.byteBuffer.put(b);
        return this;
    }

    @Override
    public LogBuffer putShort(short s) throws IOException {
        this.ensureCapacity(2);
        this.byteBuffer.putShort(s);
        return this;
    }

    @Override
    public LogBuffer putInt(int i) throws IOException {
        this.ensureCapacity(4);
        this.byteBuffer.putInt(i);
        return this;
    }

    @Override
    public LogBuffer putLong(long l) throws IOException {
        this.ensureCapacity(8);
        this.byteBuffer.putLong(l);
        return this;
    }

    @Override
    public LogBuffer putFloat(float f) throws IOException {
        this.ensureCapacity(4);
        this.byteBuffer.putFloat(f);
        return this;
    }

    @Override
    public LogBuffer putDouble(double d) throws IOException {
        this.ensureCapacity(8);
        this.byteBuffer.putDouble(d);
        return this;
    }

    @Override
    public LogBuffer put(byte[] bytes) throws IOException {
        this.put(bytes, 0);
        return this;
    }

    private void put(byte[] bytes, int offset) throws IOException {
        int bytesToWrite = bytes.length - offset;
        if (bytesToWrite > 524288) {
            bytesToWrite = 524288;
        }
        this.ensureCapacity(bytesToWrite);
        this.byteBuffer.put(bytes, offset, bytesToWrite);
        if ((offset += bytesToWrite) < bytes.length) {
            this.put(bytes, offset);
        }
    }

    @Override
    public LogBuffer put(char[] chars) throws IOException {
        this.put(chars, 0);
        return this;
    }

    private void put(char[] chars, int offset) throws IOException {
        int charsToWrite = chars.length - offset;
        if (charsToWrite * 2 > 524288) {
            charsToWrite = 262144;
        }
        this.ensureCapacity(charsToWrite * 2);
        int oldPos = this.byteBuffer.position();
        this.byteBuffer.asCharBuffer().put(chars, offset, charsToWrite);
        this.byteBuffer.position(oldPos + charsToWrite * 2);
        if ((offset += charsToWrite) < chars.length) {
            this.put(chars, offset);
        }
    }

    @Override
    public void writeOut() throws IOException {
        this.byteBuffer.flip();
        int bytesToWrite = this.byteBuffer.limit();
        this.fileChannel.writeAll(this.byteBuffer, this.bufferStartPosition);
        this.bufferStartPosition += (long)bytesToWrite;
        this.monitor.bytesWritten(bytesToWrite);
        this.byteBuffer.clear();
    }

    @Override
    public void force() throws IOException {
        this.writeOut();
        this.fileChannel.force(false);
    }

    @Override
    public long getFileChannelPosition() {
        if (this.byteBuffer != null) {
            return this.bufferStartPosition + (long)this.byteBuffer.position();
        }
        return this.bufferStartPosition;
    }

    @Override
    public StoreChannel getFileChannel() {
        return this.fileChannel;
    }

    @Override
    public ReadableByteChannel getReadableChannel() {
        return this.fileChannel;
    }
}

