/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.Serializable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.DeleteWorkDelegate;
import org.hibernate.search.bridge.util.impl.NumericFieldUtils;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public final class DeleteExtWorkDelegate
extends DeleteWorkDelegate {
    private final Class<?> managedType;
    private final DocumentBuilderIndexedEntity<?> builder;
    private static final Log log = LoggerFactory.make();
    private final boolean idIsNumeric;

    DeleteExtWorkDelegate(Workspace workspace) {
        super(workspace);
        this.managedType = workspace.getEntitiesInIndexManager().iterator().next();
        this.builder = workspace.getDocumentBuilder(this.managedType);
        this.idIsNumeric = DeleteExtWorkDelegate.isIdNumeric(this.builder);
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
        this.checkType(work);
        Serializable id = work.getId();
        log.tracef("Removing %s#%s by id using an IndexWriter.", this.managedType, id);
        try {
            if (this.idIsNumeric) {
                writer.deleteDocuments(NumericFieldUtils.createExactMatchQuery(this.builder.getIdKeywordName(), id));
            } else {
                Term idTerm = new Term(this.builder.getIdKeywordName(), work.getIdInString());
                writer.deleteDocuments(idTerm);
            }
            this.workspace.notifyWorkApplied(work);
        }
        catch (Exception e) {
            String message = "Unable to remove " + this.managedType + "#" + id + " from index.";
            throw new SearchException(message, e);
        }
    }

    private void checkType(LuceneWork work) {
        if (work.getEntityClass() != this.managedType) {
            throw new AssertionFailure("Unexpected type");
        }
    }
}

