/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hibernate.LockMode;
import org.hibernate.dialect.lock.LockingStrategy;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.impl.CouchDBDatastore;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.AssociationDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.backend.json.impl.EntityDocument;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBAssociation;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBAssociationSnapshot;
import org.hibernate.ogm.datastore.couchdb.dialect.model.impl.CouchDBTupleSnapshot;
import org.hibernate.ogm.datastore.couchdb.dialect.type.impl.CouchDBBlobType;
import org.hibernate.ogm.datastore.couchdb.dialect.type.impl.CouchDBByteType;
import org.hibernate.ogm.datastore.couchdb.dialect.type.impl.CouchDBLongType;
import org.hibernate.ogm.datastore.couchdb.impl.CouchDBDatastoreProvider;
import org.hibernate.ogm.datastore.couchdb.util.impl.Identifier;
import org.hibernate.ogm.datastore.document.options.AssociationStorageType;
import org.hibernate.ogm.datastore.document.options.spi.AssociationStorageOption;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.BaseGridDialect;
import org.hibernate.ogm.dialect.spi.ModelConsumer;
import org.hibernate.ogm.dialect.spi.NextValueRequest;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationKind;
import org.hibernate.ogm.model.spi.AssociationSnapshot;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.model.spi.TupleSnapshot;
import org.hibernate.ogm.type.impl.Iso8601StringCalendarType;
import org.hibernate.ogm.type.impl.Iso8601StringDateType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.persister.entity.Lockable;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class CouchDBDialect
extends BaseGridDialect {
    private final CouchDBDatastoreProvider provider;

    public CouchDBDialect(CouchDBDatastoreProvider provider) {
        this.provider = provider;
    }

    public LockingStrategy getLockingStrategy(Lockable lockable, LockMode lockMode) {
        return null;
    }

    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        EntityDocument entity = this.getDataStore().getEntity(Identifier.createEntityId(key));
        if (entity != null) {
            return new Tuple((TupleSnapshot)new CouchDBTupleSnapshot(entity.getProperties()));
        }
        return null;
    }

    public Tuple createTuple(EntityKey key, TupleContext tupleContext) {
        return new Tuple((TupleSnapshot)new CouchDBTupleSnapshot(key));
    }

    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        CouchDBTupleSnapshot snapshot = (CouchDBTupleSnapshot)tuple.getSnapshot();
        String revision = (String)snapshot.get("_rev");
        if (revision == null && !snapshot.isCreatedOnInsert()) {
            revision = this.getDataStore().getCurrentRevision(Identifier.createEntityId(key), false);
        }
        this.getDataStore().saveDocument(new EntityDocument(key, revision, tuple));
    }

    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        this.removeDocumentIfPresent(Identifier.createEntityId(key));
    }

    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        CouchDBAssociation couchDBAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            EntityDocument owningEntity = this.getDataStore().getEntity(Identifier.createEntityId(key.getEntityKey()));
            if (owningEntity != null && owningEntity.getProperties().containsKey(key.getMetadata().getCollectionRole())) {
                couchDBAssociation = CouchDBAssociation.fromEmbeddedAssociation(owningEntity, key.getMetadata().getCollectionRole());
            }
        } else {
            AssociationDocument association = this.getDataStore().getAssociation(Identifier.createAssociationId(key));
            if (association != null) {
                couchDBAssociation = CouchDBAssociation.fromAssociationDocument(association);
            }
        }
        return couchDBAssociation != null ? new Association((AssociationSnapshot)new CouchDBAssociationSnapshot(couchDBAssociation, key)) : null;
    }

    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        CouchDBAssociation couchDBAssociation = null;
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            EntityDocument owningEntity = this.getDataStore().getEntity(Identifier.createEntityId(key.getEntityKey()));
            if (owningEntity == null) {
                owningEntity = (EntityDocument)this.getDataStore().saveDocument(new EntityDocument(key.getEntityKey()));
            }
            couchDBAssociation = CouchDBAssociation.fromEmbeddedAssociation(owningEntity, key.getMetadata().getCollectionRole());
        } else {
            AssociationDocument association = new AssociationDocument(Identifier.createAssociationId(key));
            couchDBAssociation = CouchDBAssociation.fromAssociationDocument(association);
        }
        return new Association((AssociationSnapshot)new CouchDBAssociationSnapshot(couchDBAssociation, key));
    }

    public void insertOrUpdateAssociation(AssociationKey associationKey, Association association, AssociationContext associationContext) {
        List<Object> rows = this.getAssociationRows(association, associationKey);
        CouchDBAssociation couchDBAssociation = ((CouchDBAssociationSnapshot)association.getSnapshot()).getCouchDbAssociation();
        couchDBAssociation.setRows(rows);
        this.getDataStore().saveDocument(couchDBAssociation.getOwningDocument());
    }

    private List<Object> getAssociationRows(Association association, AssociationKey associationKey) {
        ArrayList<Object> rows = new ArrayList<Object>(association.getKeys().size());
        for (RowKey rowKey : association.getKeys()) {
            HashMap<String, Object> row;
            Tuple tuple = association.get(rowKey);
            String[] columnsToPersist = associationKey.getMetadata().getColumnsWithoutKeyColumns((Iterable)tuple.getColumnNames());
            if (columnsToPersist.length == 1) {
                row = tuple.get(columnsToPersist[0]);
                rows.add(row);
                continue;
            }
            row = new HashMap<String, Object>(columnsToPersist.length);
            for (String columnName : columnsToPersist) {
                row.put(columnName, tuple.get(columnName));
            }
            rows.add(row);
        }
        return rows;
    }

    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (this.isStoredInEntityStructure(key.getMetadata(), associationContext.getAssociationTypeContext())) {
            EntityDocument owningEntity = this.getDataStore().getEntity(Identifier.createEntityId(key.getEntityKey()));
            if (owningEntity != null) {
                owningEntity.removeAssociation(key.getMetadata().getCollectionRole());
                this.getDataStore().saveDocument(owningEntity);
            }
        } else {
            this.removeDocumentIfPresent(Identifier.createAssociationId(key));
        }
    }

    public boolean isStoredInEntityStructure(AssociationKeyMetadata associationKeyMetadata, AssociationTypeContext associationTypeContext) {
        AssociationStorageType associationStorage = (AssociationStorageType)associationTypeContext.getOptionsContext().getUnique(AssociationStorageOption.class);
        return associationKeyMetadata.getAssociationKind() == AssociationKind.EMBEDDED_COLLECTION || associationStorage == AssociationStorageType.IN_ENTITY;
    }

    public Number nextValue(NextValueRequest request) {
        return this.getDataStore().nextValue(request.getKey(), request.getIncrement(), request.getInitialValue());
    }

    public GridType overrideType(Type type) {
        if (type == StandardBasicTypes.MATERIALIZED_BLOB) {
            return CouchDBBlobType.INSTANCE;
        }
        if (type == StandardBasicTypes.CALENDAR) {
            return Iso8601StringCalendarType.DATE_TIME;
        }
        if (type == StandardBasicTypes.CALENDAR_DATE) {
            return Iso8601StringCalendarType.DATE;
        }
        if (type == StandardBasicTypes.DATE) {
            return Iso8601StringDateType.DATE;
        }
        if (type == StandardBasicTypes.TIME) {
            return Iso8601StringDateType.TIME;
        }
        if (type == StandardBasicTypes.TIMESTAMP) {
            return Iso8601StringDateType.DATE_TIME;
        }
        if (type == StandardBasicTypes.BYTE) {
            return CouchDBByteType.INSTANCE;
        }
        if (type == StandardBasicTypes.LONG) {
            return CouchDBLongType.INSTANCE;
        }
        return null;
    }

    public void forEachTuple(ModelConsumer consumer, EntityKeyMetadata ... entityKeyMetadatas) {
        for (EntityKeyMetadata entityKeyMetadata : entityKeyMetadatas) {
            this.forTuple(consumer, entityKeyMetadata);
        }
    }

    private void forTuple(ModelConsumer consumer, EntityKeyMetadata entityKeyMetadata) {
        List<Tuple> tuples = this.getTuples(entityKeyMetadata);
        for (Tuple tuple : tuples) {
            consumer.consume(tuple);
        }
    }

    private List<Tuple> getTuples(EntityKeyMetadata entityKeyMetadata) {
        return this.getDataStore().getTuples(entityKeyMetadata);
    }

    private CouchDBDatastore getDataStore() {
        return this.provider.getDataStore();
    }

    private void removeDocumentIfPresent(String id) {
        String currentRevision = this.getDataStore().getCurrentRevision(id, false);
        if (currentRevision != null) {
            this.getDataStore().deleteDocument(id, currentRevision);
        }
    }
}

