/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.couchdb.dialect.model.impl;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.SingleColumnAwareAssociationRowFactory;

public class CouchDBAssociationRowFactory
extends SingleColumnAwareAssociationRowFactory<Map<String, Object>> {
    public static final CouchDBAssociationRowFactory INSTANCE = new CouchDBAssociationRowFactory();

    private CouchDBAssociationRowFactory() {
        super(Map.class);
    }

    protected Map<String, Object> getSingleColumnRow(String columnName, Object value) {
        return Collections.singletonMap(columnName, value);
    }

    protected AssociationRow.AssociationRowAccessor<Map<String, Object>> getAssociationRowAccessor() {
        return CouchDBAssociationRowAccessor.INSTANCE;
    }

    private static class CouchDBAssociationRowAccessor
    implements AssociationRow.AssociationRowAccessor<Map<String, Object>> {
        private static final CouchDBAssociationRowAccessor INSTANCE = new CouchDBAssociationRowAccessor();

        private CouchDBAssociationRowAccessor() {
        }

        public Set<String> getColumnNames(Map<String, Object> row) {
            return row.keySet();
        }

        public Object get(Map<String, Object> row, String column) {
            return row.get(column);
        }
    }
}

