/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.datastore.document.association.spi;

import org.hibernate.ogm.datastore.document.association.spi.AssociationRow;
import org.hibernate.ogm.datastore.document.association.spi.AssociationRowFactory;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.util.impl.Contracts;

public abstract class SingleColumnAwareAssociationRowFactory<R>
implements AssociationRowFactory {
    private final Class<?> associationRowType;

    protected SingleColumnAwareAssociationRowFactory(Class<?> associationRowType) {
        this.associationRowType = associationRowType;
    }

    @Override
    public AssociationRow<?> createAssociationRow(AssociationKey associationKey, Object row) {
        Object rowObject = null;
        if (this.associationRowType.isInstance(row)) {
            rowObject = row;
        } else {
            String columnName = associationKey.getMetadata().getSingleRowKeyColumnNotContainedInAssociationKey();
            Contracts.assertNotNull(columnName, "columnName");
            rowObject = this.getSingleColumnRow(columnName, row);
        }
        return new AssociationRow<Object>(associationKey, this.getAssociationRowAccessor(), rowObject);
    }

    protected abstract R getSingleColumnRow(String var1, Object var2);

    protected abstract AssociationRow.AssociationRowAccessor<R> getAssociationRowAccessor();
}

