/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.dialect.impl;

import java.io.Serializable;
import org.hibernate.ogm.dialect.batch.spi.BatchableGridDialect;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.InsertOrUpdateTupleOperation;
import org.hibernate.ogm.dialect.batch.spi.OperationsQueue;
import org.hibernate.ogm.dialect.batch.spi.RemoveAssociationOperation;
import org.hibernate.ogm.dialect.batch.spi.RemoveTupleOperation;
import org.hibernate.ogm.dialect.impl.AssociationContextImpl;
import org.hibernate.ogm.dialect.impl.ForwardingGridDialect;
import org.hibernate.ogm.dialect.impl.TupleContextImpl;
import org.hibernate.ogm.dialect.spi.AssociationContext;
import org.hibernate.ogm.dialect.spi.TupleContext;
import org.hibernate.ogm.model.key.spi.AssociationKey;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.Tuple;

public class BatchOperationsDelegator
extends ForwardingGridDialect<Serializable> {
    private final ThreadLocal<OperationsQueue> operationQueueLocal = new ThreadLocal();

    public BatchOperationsDelegator(BatchableGridDialect dialect) {
        super(dialect);
    }

    public void prepareBatch() {
        this.operationQueueLocal.set(new OperationsQueue());
    }

    private boolean isBatchDisabled() {
        return this.getOperationQueue().isClosed();
    }

    public void clearBatch() {
        this.operationQueueLocal.remove();
    }

    private OperationsQueue getOperationQueue() {
        OperationsQueue operationsQueue = this.operationQueueLocal.get();
        if (operationsQueue == null) {
            return OperationsQueue.CLOSED_QUEUE;
        }
        return operationsQueue;
    }

    public void executeBatch() {
        super.executeBatch(this.getOperationQueue());
    }

    @Override
    public Tuple getTuple(EntityKey key, TupleContext tupleContext) {
        TupleContextImpl contextWithQueue = new TupleContextImpl((TupleContextImpl)tupleContext, this.getOperationQueue());
        return super.getTuple(key, contextWithQueue);
    }

    @Override
    public void insertOrUpdateTuple(EntityKey key, Tuple tuple, TupleContext tupleContext) {
        if (this.isBatchDisabled()) {
            super.insertOrUpdateTuple(key, tuple, tupleContext);
        } else {
            this.getOperationQueue().add(new InsertOrUpdateTupleOperation(tuple, key, tupleContext));
        }
    }

    @Override
    public void removeTuple(EntityKey key, TupleContext tupleContext) {
        if (this.isBatchDisabled()) {
            super.removeTuple(key, tupleContext);
        } else {
            this.getOperationQueue().add(new RemoveTupleOperation(key, tupleContext));
        }
    }

    @Override
    public Association getAssociation(AssociationKey key, AssociationContext associationContext) {
        return super.getAssociation(key, this.withQueue(associationContext));
    }

    @Override
    public Association createAssociation(AssociationKey key, AssociationContext associationContext) {
        return super.createAssociation(key, this.withQueue(associationContext));
    }

    @Override
    public void insertOrUpdateAssociation(AssociationKey key, Association association, AssociationContext associationContext) {
        if (this.isBatchDisabled()) {
            super.insertOrUpdateAssociation(key, association, this.withQueue(associationContext));
        } else {
            this.getOperationQueue().add(new InsertOrUpdateAssociationOperation(association, key, this.withQueue(associationContext)));
        }
    }

    @Override
    public void removeAssociation(AssociationKey key, AssociationContext associationContext) {
        if (this.isBatchDisabled()) {
            super.removeAssociation(key, this.withQueue(associationContext));
        } else {
            this.getOperationQueue().add(new RemoveAssociationOperation(key, this.withQueue(associationContext)));
        }
    }

    private AssociationContext withQueue(AssociationContext associationContext) {
        return new AssociationContextImpl((AssociationContextImpl)associationContext, this.getOperationQueue());
    }
}

