/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

import java.util.ArrayList;
import java.util.Arrays;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.spi.AssociationKind;
import org.hibernate.ogm.util.impl.ArrayHelper;

public class AssociationKeyMetadata {
    private final String table;
    private final String[] columnNames;
    private final int hashCode;
    private final String[] rowKeyColumnNames;
    private final String[] rowKeyIndexColumnNames;
    private final boolean isInverse;
    private final AssociatedEntityKeyMetadata associatedEntityKeyMetadata;
    private final String collectionRole;
    private final AssociationKind associationKind;
    private final boolean isOneToOne;

    private AssociationKeyMetadata(Builder builder) {
        this.table = builder.table;
        this.columnNames = builder.columnNames;
        this.rowKeyColumnNames = builder.rowKeyColumnNames;
        this.rowKeyIndexColumnNames = builder.rowKeyIndexColumnNames;
        this.isInverse = builder.isInverse;
        this.associatedEntityKeyMetadata = builder.associatedEntityKeyMetadata;
        this.collectionRole = builder.collectionRole;
        this.associationKind = builder.associationKind;
        this.isOneToOne = builder.isOneToOne;
        this.hashCode = this.table.hashCode();
    }

    public String getTable() {
        return this.table;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public String[] getRowKeyColumnNames() {
        return this.rowKeyColumnNames;
    }

    public String[] getRowKeyIndexColumnNames() {
        return this.rowKeyIndexColumnNames;
    }

    public AssociatedEntityKeyMetadata getAssociatedEntityKeyMetadata() {
        return this.associatedEntityKeyMetadata;
    }

    public String[] getColumnsWithoutKeyColumns(Iterable<String> candidates) {
        ArrayList<String> nonKeyColumns = new ArrayList<String>();
        for (String column : candidates) {
            if (this.isKeyColumn(column)) continue;
            nonKeyColumns.add(column);
        }
        return nonKeyColumns.toArray(new String[nonKeyColumns.size()]);
    }

    public String getSingleRowKeyColumnNotContainedInAssociationKey() {
        String nonKeyColumn = null;
        for (String column : this.getRowKeyColumnNames()) {
            if (this.isKeyColumn(column)) continue;
            if (nonKeyColumn != null) {
                return null;
            }
            nonKeyColumn = column;
        }
        return nonKeyColumn;
    }

    public boolean isKeyColumn(String columnName) {
        for (String keyColumName : this.getColumnNames()) {
            if (!keyColumName.equals(columnName)) continue;
            return true;
        }
        return false;
    }

    public boolean isInverse() {
        return this.isInverse;
    }

    public String getCollectionRole() {
        return this.collectionRole;
    }

    public AssociationKind getAssociationKind() {
        return this.associationKind;
    }

    public boolean isOneToOne() {
        return this.isOneToOne;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || AssociationKeyMetadata.class != o.getClass()) {
            return false;
        }
        AssociationKeyMetadata that = (AssociationKeyMetadata)o;
        if (!this.table.equals(that.table)) {
            return false;
        }
        return Arrays.equals(this.columnNames, that.columnNames);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return "AssociationKeyMetadata [table=" + this.table + ", columnNames=" + Arrays.toString(this.columnNames) + ", isInverse=" + this.isInverse + ", collectionRole=" + this.collectionRole + ", associationKind=" + (Object)((Object)this.associationKind) + ", rowKeyColumnNames=" + Arrays.toString(this.rowKeyColumnNames) + ", rowKeyIndexColumnNames=" + Arrays.toString(this.rowKeyIndexColumnNames) + ", associatedEntityKeyMetadata=" + this.associatedEntityKeyMetadata + "]";
    }

    public static class Builder {
        private String table;
        private String[] columnNames;
        private String[] rowKeyColumnNames;
        private String[] rowKeyIndexColumnNames = ArrayHelper.EMPTY_STRING_ARRAY;
        private boolean isInverse;
        private AssociatedEntityKeyMetadata associatedEntityKeyMetadata;
        private String collectionRole;
        private AssociationKind associationKind;
        private boolean isOneToOne;

        public Builder table(String table) {
            this.table = table;
            return this;
        }

        public Builder columnNames(String[] columnNames) {
            this.columnNames = columnNames;
            return this;
        }

        public Builder rowKeyColumnNames(String[] rowKeyColumnNames) {
            this.rowKeyColumnNames = rowKeyColumnNames;
            return this;
        }

        public Builder rowKeyIndexColumnNames(String[] rowKeyIndexColumnNames) {
            this.rowKeyIndexColumnNames = rowKeyIndexColumnNames;
            return this;
        }

        public Builder inverse(boolean isInverse) {
            this.isInverse = isInverse;
            return this;
        }

        public Builder associatedEntityKeyMetadata(AssociatedEntityKeyMetadata associatedEntityKeyMetadata) {
            this.associatedEntityKeyMetadata = associatedEntityKeyMetadata;
            return this;
        }

        public Builder collectionRole(String collectionRole) {
            this.collectionRole = collectionRole;
            return this;
        }

        public Builder associationKind(AssociationKind associationKind) {
            this.associationKind = associationKind;
            return this;
        }

        public Builder oneToOne(boolean isOneToOne) {
            this.isOneToOne = isOneToOne;
            return this;
        }

        public AssociationKeyMetadata build() {
            return new AssociationKeyMetadata(this);
        }
    }
}

