/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.model.key.spi;

public class IdSourceKeyMetadata {
    private final IdSourceType type;
    private final String name;
    private final String keyColumnName;
    private final String valueColumnName;
    private final int hashCode;

    private IdSourceKeyMetadata(IdSourceType type, String name, String keyColumnName, String valueColumnName) {
        this.type = type;
        this.name = name;
        this.keyColumnName = keyColumnName;
        this.valueColumnName = valueColumnName;
        this.hashCode = this.calculateHashCode();
    }

    public static IdSourceKeyMetadata forTable(String table, String keyColumnName, String valueColumnName) {
        return new IdSourceKeyMetadata(IdSourceType.TABLE, table, keyColumnName, valueColumnName);
    }

    public static IdSourceKeyMetadata forSequence(String sequence) {
        return new IdSourceKeyMetadata(IdSourceType.SEQUENCE, sequence, null, null);
    }

    public IdSourceType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IdSourceKeyMetadata other = (IdSourceKeyMetadata)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String toString() {
        return "IdSourceKeyMetadata [type=" + (Object)((Object)this.type) + ", name=" + this.name + ", keyColumnName=" + this.keyColumnName + ", valueColumnName=" + this.valueColumnName + "]";
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public static enum IdSourceType {
        TABLE,
        SEQUENCE;

    }
}

