/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.options.navigation.source.impl;

import java.util.Collections;
import java.util.Map;
import org.hibernate.ogm.options.container.impl.OptionsContainer;
import org.hibernate.ogm.options.navigation.source.impl.OptionValueSource;
import org.hibernate.ogm.options.spi.Option;
import org.hibernate.ogm.options.spi.UniqueOption;
import org.hibernate.ogm.util.configurationreader.spi.ConfigurationPropertyReader;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;

public class ConfigurationOptionValueSource
implements OptionValueSource {
    private final ConfigurationBasedOptionContainer globalOptions;

    public ConfigurationOptionValueSource(ConfigurationPropertyReader reader) {
        this.globalOptions = new ConfigurationBasedOptionContainer(reader);
    }

    @Override
    public OptionsContainer getGlobalOptions() {
        return this.globalOptions;
    }

    @Override
    public OptionsContainer getEntityOptions(Class<?> entityType) {
        return OptionsContainer.EMPTY;
    }

    @Override
    public OptionsContainer getPropertyOptions(Class<?> entityType, String propertyName) {
        return OptionsContainer.EMPTY;
    }

    private static class ConfigurationBasedOptionContainer
    implements OptionsContainer {
        private static final Log log = LoggerFactory.make();
        private final ConfigurationPropertyReader propertyReader;

        public ConfigurationBasedOptionContainer(ConfigurationPropertyReader propertyReader) {
            this.propertyReader = propertyReader;
        }

        @Override
        public <I, V> V get(Class<? extends Option<I, V>> optionType, I identifier) {
            return null;
        }

        @Override
        public <V> V getUnique(Class<? extends UniqueOption<V>> optionType) {
            try {
                return optionType.newInstance().getDefaultValue(this.propertyReader);
            }
            catch (Exception e) {
                throw log.unableToInstantiateType(optionType.getName(), e);
            }
        }

        @Override
        public <I, V, T extends Option<I, V>> Map<I, V> getAll(Class<T> optionType) {
            try {
                Option option = (Option)optionType.newInstance();
                Object value = option.getDefaultValue(this.propertyReader);
                return value != null ? Collections.singletonMap(option.getOptionIdentifier(), value) : Collections.emptyMap();
            }
            catch (Exception e) {
                throw log.unableToInstantiateType(optionType.getName(), e);
            }
        }
    }
}

