/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.persister.impl;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.spi.access.CollectionRegionAccessStrategy;
import org.hibernate.cfg.Configuration;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SubselectFetch;
import org.hibernate.internal.FilterAliasGenerator;
import org.hibernate.internal.StaticFilterAliasGenerator;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.mapping.Collection;
import org.hibernate.ogm.dialect.impl.AssociationTypeContextImpl;
import org.hibernate.ogm.dialect.spi.AssociationTypeContext;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.jdbc.impl.TupleAsMapResultSet;
import org.hibernate.ogm.loader.impl.OgmBasicCollectionLoader;
import org.hibernate.ogm.model.impl.EntityKeyBuilder;
import org.hibernate.ogm.model.impl.RowKeyBuilder;
import org.hibernate.ogm.model.key.spi.AssociatedEntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.AssociationKeyMetadata;
import org.hibernate.ogm.model.key.spi.EntityKey;
import org.hibernate.ogm.model.key.spi.EntityKeyMetadata;
import org.hibernate.ogm.model.key.spi.RowKey;
import org.hibernate.ogm.model.spi.Association;
import org.hibernate.ogm.model.spi.AssociationKind;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.options.spi.OptionsService;
import org.hibernate.ogm.persister.impl.BiDirectionalAssociationHelper;
import org.hibernate.ogm.persister.impl.CollectionPhysicalModel;
import org.hibernate.ogm.persister.impl.OgmEntityPersister;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.AssociationPersister;
import org.hibernate.ogm.util.impl.Contracts;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.ogm.util.impl.LogicalPhysicalConverterHelper;
import org.hibernate.persister.collection.AbstractCollectionPersister;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.pretty.MessageHelper;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public class OgmCollectionPersister
extends AbstractCollectionPersister
implements CollectionPhysicalModel {
    private static final Log log = LoggerFactory.make();
    private final GridType keyGridType;
    private final GridType elementGridType;
    private final GridType indexGridType;
    private final GridType identifierGridType;
    private final boolean isInverse;
    private final boolean oneToMany;
    private final GridType gridTypeOfAssociatedId;
    private final AssociationType associationType;
    private final GridDialect gridDialect;
    private final AssociationKeyMetadata associationKeyMetadata;
    private final String nodeName;
    private OgmCollectionPersister inverseCollectionPersister;
    private String mainSidePropertyName;
    private AssociationTypeContext associationTypeContext;

    public OgmCollectionPersister(Collection collection, CollectionRegionAccessStrategy cacheAccessStrategy, Configuration cfg, SessionFactoryImplementor factory) throws MappingException, CacheException {
        super(collection, cacheAccessStrategy, cfg, factory);
        Type identifierOrUniqueKeyType;
        ServiceRegistryImplementor registry = factory.getServiceRegistry();
        TypeTranslator typeTranslator = (TypeTranslator)registry.getService(TypeTranslator.class);
        this.gridDialect = (GridDialect)registry.getService(GridDialect.class);
        this.keyGridType = typeTranslator.getType(this.getKeyType());
        this.elementGridType = typeTranslator.getType(this.getElementType());
        this.indexGridType = typeTranslator.getType(this.getIndexType());
        this.identifierGridType = typeTranslator.getType(this.getIdentifierType());
        this.isInverse = collection.isInverse();
        this.oneToMany = collection.isOneToMany();
        if (collection.isOneToMany() && this.getElementPersister() != null && this.getElementType().isEntityType()) {
            this.associationType = AssociationType.EMBEDDED_FK_TO_ENTITY;
            identifierOrUniqueKeyType = ((EntityType)this.getElementType()).getIdentifierOrUniqueKeyType((Mapping)factory);
            this.gridTypeOfAssociatedId = typeTranslator.getType(identifierOrUniqueKeyType);
        } else {
            if (collection.isOneToMany()) {
                throw new AssertionFailure("Association marked as one to many but has no ManyToOneType: " + collection.getRole());
            }
            if (this.getElementType().isAssociationType() && this.getElementType().isEntityType()) {
                this.associationType = AssociationType.ASSOCIATION_TABLE_TO_ENTITY;
                identifierOrUniqueKeyType = ((EntityType)this.getElementType()).getIdentifierOrUniqueKeyType((Mapping)factory);
                this.gridTypeOfAssociatedId = typeTranslator.getType(identifierOrUniqueKeyType);
            } else {
                this.gridTypeOfAssociatedId = null;
                this.associationType = AssociationType.OTHER;
            }
        }
        RowKeyBuilder rowKeyBuilder = this.initializeRowKeyBuilder();
        String[] rowKeyColumnNames = rowKeyBuilder.getColumnNames();
        String[] rowKeyIndexColumnNames = rowKeyBuilder.getIndexColumnNames();
        this.associationKeyMetadata = new AssociationKeyMetadata.Builder().table(this.getTableName()).columnNames(this.getKeyColumnNames()).rowKeyColumnNames(rowKeyColumnNames).rowKeyIndexColumnNames(rowKeyIndexColumnNames).associatedEntityKeyMetadata(new AssociatedEntityKeyMetadata(this.getElementColumnNames(), this.targetEntityKeyMetadata(false))).inverse(this.isInverse).collectionRole(this.getUnqualifiedRole()).associationKind(this.getElementType().isEntityType() ? AssociationKind.ASSOCIATION : AssociationKind.EMBEDDED_COLLECTION).oneToOne(false).build();
        this.nodeName = collection.getNodeName();
    }

    public String getUnqualifiedRole() {
        String entity = this.getOwnerEntityPersister().getEntityName();
        String role = this.getRole();
        return role.substring(entity.length() + 1);
    }

    private EntityKeyMetadata targetEntityKeyMetadata(boolean inverse) {
        if (inverse) {
            return ((OgmEntityPersister)this.getOwnerEntityPersister()).getEntityKeyMetadata();
        }
        if (this.getElementType().isEntityType()) {
            return ((OgmEntityPersister)this.getElementPersister()).getEntityKeyMetadata();
        }
        String[] targetColumnNames = null;
        targetColumnNames = inverse ? this.getKeyColumnNames() : this.getElementColumnNames();
        return new EntityKeyMetadata(this.getTableName(), targetColumnNames);
    }

    public AssociationKeyMetadata getAssociationKeyMetadata() {
        return this.associationKeyMetadata;
    }

    public Object readKey(ResultSet rs, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.keyGridType.nullSafeGet(keyTuple, aliases, session, null);
    }

    public Object readElement(ResultSet rs, Object owner, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.elementGridType.nullSafeGet(keyTuple, aliases, session, owner);
    }

    public Object readIdentifier(ResultSet rs, String alias, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.identifierGridType.nullSafeGet(keyTuple, alias, session, null);
    }

    public Object readIndex(ResultSet rs, String[] aliases, SessionImplementor session) throws HibernateException, SQLException {
        TupleAsMapResultSet resultset = rs.unwrap(TupleAsMapResultSet.class);
        Tuple keyTuple = resultset.getTuple();
        return this.indexGridType.nullSafeGet(keyTuple, aliases, session, null);
    }

    protected CollectionInitializer createSubselectInitializer(SubselectFetch subselect, SessionImplementor session) {
        return null;
    }

    protected CollectionInitializer createCollectionInitializer(LoadQueryInfluencers loadQueryInfluencers) throws MappingException {
        return new OgmBasicCollectionLoader(this);
    }

    @Override
    public GridType getKeyGridType() {
        return this.keyGridType;
    }

    @Override
    public GridType getElementGridType() {
        return this.elementGridType;
    }

    public boolean isOneToMany() {
        return this.oneToMany;
    }

    public boolean isManyToMany() {
        return true;
    }

    public boolean isCascadeDeleteEnabled() {
        return false;
    }

    protected String generateDeleteString() {
        return null;
    }

    protected String generateDeleteRowString() {
        return null;
    }

    protected String generateUpdateRowString() {
        return null;
    }

    protected String generateInsertRowString() {
        return null;
    }

    protected int doUpdateRows(Serializable key, PersistentCollection collection, SessionImplementor session) throws HibernateException {
        if (ArrayHelper.isAllFalse((boolean[])this.elementColumnIsSettable)) {
            return 0;
        }
        int count = 0;
        int i = 0;
        Iterator entries = collection.entries((CollectionPersister)this);
        AssociationPersister associationPersister = this.getAssociationPersister(collection.getOwner(), key, session);
        while (entries.hasNext()) {
            Object entry = entries.next();
            if (collection.needsUpdating(entry, i, this.elementType)) {
                RowKey assocEntryKey = this.getTupleKeyForUpdate(key, collection, session, i, entry, associationPersister);
                Tuple assocEntryTuple = associationPersister.getAssociation().get(assocEntryKey);
                if (assocEntryTuple == null) {
                    throw new AssertionFailure("Updating a collection tuple that is not present: table {" + this.getTableName() + "} collectionKey {" + key + "} entry {" + entry + "}");
                }
                this.updateInverseSideOfAssociationNavigation(session, entry, assocEntryTuple, Action.REMOVE, assocEntryKey);
                this.getElementGridType().nullSafeSet(assocEntryTuple, collection.getElement(entry), this.getElementColumnNames(), session);
                associationPersister.getAssociation().put(assocEntryKey, assocEntryTuple);
                this.updateInverseSideOfAssociationNavigation(session, entry, assocEntryTuple, Action.ADD, assocEntryKey);
                ++count;
            }
            ++i;
        }
        associationPersister.flushToDatastore();
        return count;
    }

    private RowKeyAndTuple createAndPutAssociationRowForInsert(Serializable key, PersistentCollection collection, AssociationPersister associationPersister, SessionImplementor session, int i, Object entry) {
        RowKeyBuilder rowKeyBuilder = this.initializeRowKeyBuilder();
        Tuple associationRow = new Tuple();
        if (this.hasIdentifier) {
            Object identifier = collection.getIdentifier(entry, i);
            String[] names = new String[]{this.getIdentifierColumnName()};
            this.identifierGridType.nullSafeSet(associationRow, identifier, names, session);
        }
        this.getKeyGridType().nullSafeSet(associationRow, key, this.getKeyColumnNames(), session);
        if (this.hasIndex) {
            Object index = collection.getIndex(entry, i, (CollectionPersister)this);
            this.indexGridType.nullSafeSet(associationRow, this.incrementIndexByBase(index), this.getIndexColumnNames(), session);
        }
        Object element = collection.getElement(entry);
        this.getElementGridType().nullSafeSet(associationRow, element, this.getElementColumnNames(), session);
        RowKeyAndTuple result = new RowKeyAndTuple();
        result.key = rowKeyBuilder.values(associationRow).build();
        result.tuple = associationRow;
        associationPersister.getAssociation().put(result.key, result.tuple);
        return result;
    }

    private RowKeyBuilder initializeRowKeyBuilder() {
        RowKeyBuilder builder = new RowKeyBuilder();
        if (this.hasIdentifier) {
            builder.addColumns(this.getIdentifierColumnName());
        } else {
            builder.addColumns(this.getKeyColumnNames());
            if (!this.isOneToMany() && this.hasIndex && !this.indexContainsFormula) {
                builder.addIndexColumns(this.getIndexColumnNames());
            } else {
                builder.addColumns(this.getElementColumnNames());
            }
        }
        return builder;
    }

    private RowKey getTupleKeyForUpdate(Serializable key, PersistentCollection collection, SessionImplementor session, int i, Object entry, AssociationPersister associationPersister) {
        RowKeyBuilder rowKeyBuilder = this.initializeRowKeyBuilder();
        Tuple tuple = new Tuple();
        if (this.hasIdentifier) {
            Object identifier = collection.getIdentifier(entry, i);
            String[] names = new String[]{this.getIdentifierColumnName()};
            this.identifierGridType.nullSafeSet(tuple, identifier, names, session);
        } else {
            this.getKeyGridType().nullSafeSet(tuple, key, this.getKeyColumnNames(), session);
            if (!this.isOneToMany() && this.hasIndex && !this.indexContainsFormula) {
                Object index = collection.getIndex(entry, i, (CollectionPersister)this);
                this.indexGridType.nullSafeSet(tuple, this.incrementIndexByBase(index), this.getIndexColumnNames(), session);
            } else {
                Object snapshotElement = collection.getSnapshotElement(entry, i);
                if (this.elementIsPureFormula) {
                    throw new AssertionFailure("cannot use a formula-based element in the where condition");
                }
                this.getElementGridType().nullSafeSet(tuple, snapshotElement, this.getElementColumnNames(), session);
            }
        }
        rowKeyBuilder.values(tuple);
        return rowKeyBuilder.build();
    }

    private RowKey getTupleKeyForDelete(Serializable key, PersistentCollection collection, SessionImplementor session, Object entry, boolean findByIndex, AssociationPersister associationPersister) {
        RowKeyBuilder rowKeyBuilder = this.initializeRowKeyBuilder();
        Tuple tuple = new Tuple();
        if (this.hasIdentifier) {
            Object identifier = entry;
            String[] names = new String[]{this.getIdentifierColumnName()};
            this.identifierGridType.nullSafeSet(tuple, identifier, names, session);
        } else {
            this.getKeyGridType().nullSafeSet(tuple, key, this.getKeyColumnNames(), session);
            if (findByIndex) {
                Object index = entry;
                this.indexGridType.nullSafeSet(tuple, this.incrementIndexByBase(index), this.getIndexColumnNames(), session);
            } else {
                Object snapshotElement = entry;
                if (this.elementIsPureFormula) {
                    throw new AssertionFailure("cannot use a formula-based element in the where condition");
                }
                this.getElementGridType().nullSafeSet(tuple, snapshotElement, this.getElementColumnNames(), session);
            }
        }
        rowKeyBuilder.values(tuple);
        return rowKeyBuilder.build();
    }

    public int getSize(Serializable key, SessionImplementor session) {
        AssociationPersister associationPersister = this.getAssociationPersister(session.getPersistenceContext().getEntity(new org.hibernate.engine.spi.EntityKey(key, this.getOwnerEntityPersister())), key, session);
        Association collectionMetadata = associationPersister.getAssociationOrNull();
        return collectionMetadata == null ? 0 : collectionMetadata.size();
    }

    public FilterAliasGenerator getFilterAliasGenerator(String rootAlias) {
        return new StaticFilterAliasGenerator(rootAlias);
    }

    public void deleteRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowDeleteEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Deleting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            boolean deleteByIndex = !this.isOneToMany() && this.hasIndex && !this.indexContainsFormula;
            AssociationPersister associationPersister = this.getAssociationPersister(collection.getOwner(), id, session);
            Iterator deletes = collection.getDeletes((CollectionPersister)this, !deleteByIndex);
            if (deletes.hasNext()) {
                int count = 0;
                while (deletes.hasNext()) {
                    Object entry = deletes.next();
                    RowKey assocEntryKey = this.getTupleKeyForDelete(id, collection, session, entry, deleteByIndex, associationPersister);
                    Tuple assocEntryTuple = associationPersister.getAssociation().get(assocEntryKey);
                    if (assocEntryTuple == null) {
                        throw new AssertionFailure("Deleting a collection tuple that is not present: table {" + this.getTableName() + "} collectionKey {" + id + "} entry {" + entry + "}");
                    }
                    this.updateInverseSideOfAssociationNavigation(session, entry, assocEntryTuple, Action.REMOVE, assocEntryKey);
                    associationPersister.getAssociation().remove(assocEntryKey);
                    ++count;
                }
                associationPersister.flushToDatastore();
                if (log.isDebugEnabled()) {
                    log.debug("done deleting collection rows: " + count + " deleted");
                }
            } else {
                log.debug("no rows to delete");
            }
        }
    }

    public void insertRows(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowInsertEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Inserting rows of collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            AssociationPersister associationPersister = this.getAssociationPersister(collection.getOwner(), id, session);
            collection.preInsert((CollectionPersister)this);
            Iterator entries = collection.entries((CollectionPersister)this);
            int i = 0;
            int count = 0;
            while (entries.hasNext()) {
                Object entry = entries.next();
                if (collection.needsInserting(entry, i, this.elementType)) {
                    RowKeyAndTuple associationRow = this.createAndPutAssociationRowForInsert(id, collection, associationPersister, session, i, entry);
                    this.updateInverseSideOfAssociationNavigation(session, entry, associationRow.tuple, Action.ADD, associationRow.key);
                    collection.afterRowInsert((CollectionPersister)this, entry, i);
                    ++count;
                }
                ++i;
            }
            associationPersister.flushToDatastore();
            if (log.isDebugEnabled()) {
                log.debug("done inserting rows: " + count + " inserted");
            }
        }
    }

    public void recreate(PersistentCollection collection, Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowInsertEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug("Inserting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            AssociationPersister associationPersister = this.getAssociationPersister(collection.getOwner(), id, session);
            Iterator entries = collection.entries((CollectionPersister)this);
            if (entries.hasNext()) {
                collection.preInsert((CollectionPersister)this);
                int i = 0;
                int count = 0;
                while (entries.hasNext()) {
                    Object entry = entries.next();
                    if (collection.entryExists(entry, i)) {
                        RowKeyAndTuple keyAndTuple = this.createAndPutAssociationRowForInsert(id, collection, associationPersister, session, i, entry);
                        this.updateInverseSideOfAssociationNavigation(session, entry, keyAndTuple.tuple, Action.ADD, keyAndTuple.key);
                        collection.afterRowInsert((CollectionPersister)this, entry, i);
                        ++count;
                    }
                    ++i;
                }
                associationPersister.flushToDatastore();
                if (log.isDebugEnabled()) {
                    log.debug("done inserting collection: " + count + " rows inserted");
                }
            } else if (log.isDebugEnabled()) {
                log.debug("collection was empty");
            }
        }
    }

    private void updateInverseSideOfAssociationNavigation(SessionImplementor session, Object entity, Tuple associationRow, Action action, RowKey rowKey) {
        if (this.associationType == AssociationType.EMBEDDED_FK_TO_ENTITY) {
            Serializable entityId = (Serializable)this.gridTypeOfAssociatedId.nullSafeGet(associationRow, this.getElementColumnNames(), session, null);
            OgmEntityPersister persister = (OgmEntityPersister)this.getElementPersister();
            EntityKey entityKey = EntityKeyBuilder.fromPersister(persister, entityId, session);
            Tuple entityTuple = this.gridDialect.getTuple(entityKey, persister.getTupleContext());
            if (entityTuple == null) {
                return;
            }
            if (action == Action.ADD) {
                for (String columnName : associationRow.getColumnNames()) {
                    entityTuple.put(columnName, associationRow.get(columnName));
                }
            } else if (action == Action.REMOVE) {
                if (this.hasIdentifier) {
                    throw new AssertionFailure("A true OneToMany with an identifier for the collection: " + this.getRole());
                }
                if (this.hasIndex) {
                    this.indexGridType.nullSafeSet(entityTuple, null, this.getIndexColumnNames(), session);
                }
                this.keyGridType.nullSafeSet(entityTuple, null, this.getKeyColumnNames(), session);
            } else {
                throw new AssertionFailure("Unknown action type: " + (Object)((Object)action));
            }
            this.gridDialect.insertOrUpdateTuple(entityKey, entityTuple, persister.getTupleContext());
        } else if (this.associationType == AssociationType.ASSOCIATION_TABLE_TO_ENTITY) {
            Object[] elementColumnNames = this.getElementColumnNames();
            Object[] elementColumnValues = LogicalPhysicalConverterHelper.getColumnValuesFromResultset(associationRow, (String[])elementColumnNames);
            Serializable entityId = (Serializable)this.gridTypeOfAssociatedId.nullSafeGet(associationRow, this.getElementColumnNames(), session, null);
            if (this.inverseCollectionPersister == null) {
                return;
            }
            if (entity == null) {
                entity = session.getPersistenceContext().getEntity(session.generateEntityKey(entityId, this.getElementPersister()));
            }
            AssociationPersister associationPersister = this.inverseCollectionPersister.getAssociationPersister(entity, elementColumnValues, session);
            if (action == Action.ADD) {
                RowKey inverseRowKey = this.getInverseRowKey(associationRow);
                Tuple inverseAssociationRow = new Tuple();
                associationPersister.getAssociation().put(inverseRowKey, inverseAssociationRow);
                for (String columnName : associationRow.getColumnNames()) {
                    inverseAssociationRow.put(columnName, associationRow.get(columnName));
                }
                associationPersister.getAssociation().put(inverseRowKey, inverseAssociationRow);
            } else if (action == Action.REMOVE) {
                if (rowKey == null) {
                    throw new AssertionFailure("Deleting a collection tuple that is not present: table {" + this.getTableName() + "} key column names {" + Arrays.toString(elementColumnNames) + "} key column values {" + Arrays.toString(elementColumnValues) + "}");
                }
                RowKey inverseRowKey = this.getInverseRowKey(associationRow);
                associationPersister.getAssociation().remove(inverseRowKey);
            } else {
                throw new AssertionFailure("Unknown action type: " + (Object)((Object)action));
            }
            associationPersister.flushToDatastore();
        }
    }

    private RowKey getInverseRowKey(Tuple associationRow) {
        String[] inverseRowKeyColumnNames = this.inverseCollectionPersister.getAssociationKeyMetadata().getRowKeyColumnNames();
        Object[] columnValues = new Object[inverseRowKeyColumnNames.length];
        for (int i = 0; i < inverseRowKeyColumnNames.length; ++i) {
            columnValues[i] = associationRow.get(inverseRowKeyColumnNames[i]);
        }
        return new RowKey(inverseRowKeyColumnNames, columnValues);
    }

    public void remove(Serializable id, SessionImplementor session) throws HibernateException {
        if (!this.isInverse && this.isRowDeleteEnabled()) {
            Object owner;
            AssociationPersister associationPersister;
            Association association;
            if (log.isDebugEnabled()) {
                log.debug("Deleting collection: " + MessageHelper.collectionInfoString((CollectionPersister)this, (Serializable)id, (SessionFactoryImplementor)this.getFactory()));
            }
            if ((association = (associationPersister = this.getAssociationPersister(owner = session.getPersistenceContext().getCollectionOwner(id, (CollectionPersister)this), id, session)).getAssociationOrNull()) != null) {
                if (this.associationType != AssociationType.OTHER) {
                    for (RowKey assocEntryKey : association.getKeys()) {
                        this.updateInverseSideOfAssociationNavigation(session, null, association.get(assocEntryKey), Action.REMOVE, assocEntryKey);
                    }
                }
                association.clear();
                associationPersister.flushToDatastore();
            }
            if (log.isDebugEnabled()) {
                log.debug("done deleting collection");
            }
        }
    }

    public String selectFragment(Joinable rhs, String rhsAlias, String lhsAlias, String currentEntitySuffix, String currentCollectionSuffix, boolean includeCollectionColumns) {
        return null;
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return null;
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses) {
        return null;
    }

    public boolean consumesEntityAlias() {
        return false;
    }

    public boolean consumesCollectionAlias() {
        return false;
    }

    protected void logStaticSQL() {
        if (log.isDebugEnabled()) {
            log.debug("No SQL used when using OGM: " + this.getRole());
        }
    }

    public void postInstantiate() throws MappingException {
        if (this.isInverse) {
            this.mainSidePropertyName = BiDirectionalAssociationHelper.getMainSidePropertyName(this);
            this.inverseCollectionPersister = null;
        } else {
            this.mainSidePropertyName = this.getUnqualifiedRole();
            this.inverseCollectionPersister = BiDirectionalAssociationHelper.getInverseCollectionPersister(this);
        }
        this.associationTypeContext = this.getAssociationTypeContext(this.mainSidePropertyName);
    }

    protected CollectionInitializer getAppropriateInitializer(Serializable key, SessionImplementor session) {
        return this.createCollectionInitializer(session.getLoadQueryInfluencers());
    }

    protected void doProcessQueuedOps(PersistentCollection collection, Serializable key, SessionImplementor session) throws HibernateException {
    }

    protected void doProcessQueuedOps(PersistentCollection collection, Serializable key, int nextIndex, SessionImplementor session) throws HibernateException {
    }

    public String whereJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses, Set<String> treatAsDeclarations) {
        return null;
    }

    public String fromJoinFragment(String alias, boolean innerJoin, boolean includeSubclasses, Set<String> treatAsDeclarations) {
        return null;
    }

    public String getMainSidePropertyName() {
        return this.mainSidePropertyName;
    }

    public AssociationTypeContext getAssociationTypeContext() {
        Contracts.assertNotNull(this.associationTypeContext, "Association type context has not yet been initialized");
        return this.associationTypeContext;
    }

    public AssociationTypeContext getAssociationTypeContext(String mainSidePropertyName) {
        OptionsService.OptionsServiceContext serviceContext = ((OptionsService)this.getFactory().getServiceRegistry().getService(OptionsService.class)).context();
        AssociationTypeContextImpl associationTypeContext = new AssociationTypeContextImpl(serviceContext.getPropertyOptions(this.getOwnerEntityPersister().getMappedClass(), this.associationKeyMetadata.getCollectionRole()), this.associationKeyMetadata.getAssociatedEntityKeyMetadata(), mainSidePropertyName);
        return associationTypeContext;
    }

    private AssociationPersister getAssociationPersister(Object collectionOwner, Serializable id, SessionImplementor session) {
        return new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).hostingEntity(collectionOwner).gridDialect(this.gridDialect).key(id, this.getKeyGridType()).associationKeyMetadata(this.associationKeyMetadata).associationTypeContext(this.associationTypeContext).session(session);
    }

    private AssociationPersister getAssociationPersister(Object collectionOwner, Object[] keyColumnValues, SessionImplementor session) {
        return new AssociationPersister(this.getOwnerEntityPersister().getMappedClass()).hostingEntity(collectionOwner).gridDialect(this.gridDialect).keyColumnValues(keyColumnValues).associationKeyMetadata(this.associationKeyMetadata).associationTypeContext(this.associationTypeContext).session(session);
    }

    private static enum Action {
        ADD,
        REMOVE;

    }

    private static class RowKeyAndTuple {
        RowKey key;
        Tuple tuple;

        private RowKeyAndTuple() {
        }
    }

    private static enum AssociationType {
        EMBEDDED_FK_TO_ENTITY,
        ASSOCIATION_TABLE_TO_ENTITY,
        OTHER;

    }
}

