/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.io.Serializable;
import java.util.Map;
import org.dom4j.Node;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.spi.Mapping;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.ogm.model.spi.Tuple;
import org.hibernate.ogm.type.descriptor.impl.GridTypeDescriptor;
import org.hibernate.ogm.type.descriptor.impl.GridValueBinder;
import org.hibernate.ogm.type.descriptor.impl.GridValueExtractor;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.StringRepresentableType;
import org.hibernate.type.XmlRepresentableType;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.MutabilityPlan;

public abstract class AbstractGenericBasicType<T>
implements GridType,
StringRepresentableType<T>,
XmlRepresentableType<T> {
    private static final boolean[] TRUE = new boolean[]{true};
    private static final boolean[] FALSE = new boolean[]{false};
    private final GridTypeDescriptor gridTypeDescriptor;
    private final JavaTypeDescriptor<T> javaTypeDescriptor;
    private final GridValueExtractor<T> typeExtractor;
    private final GridValueBinder<T> typeBinder;

    public AbstractGenericBasicType(GridTypeDescriptor gridTypeDescriptor, JavaTypeDescriptor<T> javaTypeDescriptor) {
        this.gridTypeDescriptor = gridTypeDescriptor;
        this.javaTypeDescriptor = javaTypeDescriptor;
        this.typeExtractor = gridTypeDescriptor.getExtractor(javaTypeDescriptor);
        this.typeBinder = gridTypeDescriptor.getBinder(javaTypeDescriptor);
    }

    public T fromString(String string) {
        return (T)this.javaTypeDescriptor.fromString(string);
    }

    public String toString(T value) {
        return this.javaTypeDescriptor.toString(value);
    }

    public T fromStringValue(String xml) throws HibernateException {
        return this.fromString(xml);
    }

    public String toXMLString(T value, SessionFactoryImplementor factory) throws HibernateException {
        return this.toString(value);
    }

    public T fromXMLString(String xml, Mapping factory) throws HibernateException {
        return xml == null || xml.length() == 0 ? null : (T)this.fromStringValue(xml);
    }

    protected MutabilityPlan<T> getMutabilityPlan() {
        return this.javaTypeDescriptor.getMutabilityPlan();
    }

    protected T getReplacement(T original, T target) {
        if (!this.isMutable()) {
            return original;
        }
        if (this.isEqual(original, target)) {
            return original;
        }
        return this.deepCopy(original);
    }

    @Override
    public boolean[] toColumnNullness(Object value, Mapping mapping) {
        return value == null ? FALSE : TRUE;
    }

    public String[] getRegistrationKeys() {
        String[] stringArray;
        if (this.registerUnderJavaType()) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = this.getName();
            stringArray = stringArray2;
            stringArray2[1] = this.javaTypeDescriptor.getJavaTypeClass().getName();
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = this.getName();
        }
        return stringArray;
    }

    protected boolean registerUnderJavaType() {
        return false;
    }

    public final JavaTypeDescriptor<T> getJavaTypeDescriptor() {
        return this.javaTypeDescriptor;
    }

    public final GridTypeDescriptor getGridTypeDescriptor() {
        return this.gridTypeDescriptor;
    }

    public final Class getReturnedClass() {
        return this.javaTypeDescriptor.getJavaTypeClass();
    }

    @Override
    public abstract int getColumnSpan(Mapping var1) throws MappingException;

    @Override
    public final boolean isAssociationType() {
        return false;
    }

    @Override
    public final boolean isCollectionType() {
        return false;
    }

    @Override
    public final boolean isComponentType() {
        return false;
    }

    @Override
    public final boolean isEntityType() {
        return false;
    }

    @Override
    public final boolean isAnyType() {
        return false;
    }

    @Override
    public final boolean isXMLElement() {
        return false;
    }

    @Override
    public final boolean isSame(Object x, Object y) {
        return this.isEqual(x, y);
    }

    @Override
    public final boolean isEqual(Object x, Object y, SessionFactoryImplementor factory) {
        return this.isEqual(x, y);
    }

    @Override
    public final boolean isEqual(Object one, Object another) {
        return this.javaTypeDescriptor.areEqual(one, another);
    }

    @Override
    public final int getHashCode(Object x, SessionFactoryImplementor factory) {
        return this.getHashCode(x);
    }

    @Override
    public final int getHashCode(Object x) {
        return this.javaTypeDescriptor.extractHashCode(x);
    }

    @Override
    public final int compare(Object x, Object y) {
        return this.javaTypeDescriptor.getComparator().compare(x, y);
    }

    @Override
    public final boolean isDirty(Object old, Object current, SessionImplementor session) {
        return this.isDirty(old, current);
    }

    @Override
    public final boolean isDirty(Object old, Object current, boolean[] checkable, SessionImplementor session) {
        return checkable[0] && this.isDirty(old, current);
    }

    protected final boolean isDirty(Object old, Object current) {
        return !this.isSame(old, current);
    }

    @Override
    public final boolean isModified(Object oldHydratedState, Object currentState, boolean[] checkable, SessionImplementor session) {
        return this.isDirty(oldHydratedState, currentState);
    }

    @Override
    public final Object nullSafeGet(Tuple rs, String[] names, SessionImplementor session, Object owner) {
        return this.nullSafeGet(rs, names[0], session);
    }

    @Override
    public final Object nullSafeGet(Tuple rs, String name, SessionImplementor session, Object owner) {
        return this.nullSafeGet(rs, name, session);
    }

    private T nullSafeGet(Tuple rs, String name, SessionImplementor session) {
        return this.nullSafeGet(rs, name, (WrapperOptions)null);
    }

    protected final T nullSafeGet(Tuple rs, String name, WrapperOptions options) {
        return this.typeExtractor.extract(rs, name);
    }

    @Override
    public final void nullSafeSet(Tuple rs, Object value, String[] names, SessionImplementor session) {
        this.nullSafeSet(rs, value, names, (WrapperOptions)null);
    }

    protected final void nullSafeSet(Tuple rs, Object value, String[] names, WrapperOptions options) {
        this.typeBinder.bind(rs, value, names);
    }

    @Override
    public final void nullSafeSet(Tuple st, Object value, String[] names, boolean[] settable, SessionImplementor session) throws HibernateException {
        if (settable.length > 1) {
            throw new NotYetImplementedException("Multi column property not implemented yet");
        }
        if (settable[0]) {
            this.nullSafeSet(st, value, names, session);
        }
    }

    @Override
    public final String toLoggableString(Object value, SessionFactoryImplementor factory) {
        return this.javaTypeDescriptor.extractLoggableRepresentation(value);
    }

    @Override
    public final void setToXMLNode(Node node, Object value, SessionFactoryImplementor factory) {
        node.setText(this.toString(value));
    }

    @Override
    public final Object fromXMLNode(Node xml, Mapping factory) {
        return this.fromString(xml.getText());
    }

    @Override
    public final boolean isMutable() {
        return this.getMutabilityPlan().isMutable();
    }

    @Override
    public Object deepCopy(Object value, SessionFactoryImplementor factory) throws HibernateException {
        return this.deepCopy(value);
    }

    protected final T deepCopy(T value) {
        return (T)this.getMutabilityPlan().deepCopy(value);
    }

    @Override
    public final Serializable disassemble(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().disassemble(value);
    }

    @Override
    public final Object assemble(Serializable cached, SessionImplementor session, Object owner) throws HibernateException {
        return this.getMutabilityPlan().assemble(cached);
    }

    @Override
    public final void beforeAssemble(Serializable cached, SessionImplementor session) {
    }

    @Override
    public final Object hydrate(Tuple rs, String[] names, SessionImplementor session, Object owner) throws HibernateException {
        return this.nullSafeGet(rs, names, session, owner);
    }

    @Override
    public final Object resolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return value;
    }

    @Override
    public final Object semiResolve(Object value, SessionImplementor session, Object owner) throws HibernateException {
        return value;
    }

    @Override
    public final GridType getSemiResolvedType(SessionFactoryImplementor factory) {
        return this;
    }

    @Override
    public final Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache) {
        return this.getReplacement(original, target);
    }

    @Override
    public Object replace(Object original, Object target, SessionImplementor session, Object owner, Map copyCache, ForeignKeyDirection foreignKeyDirection) {
        return ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT == foreignKeyDirection ? this.getReplacement(original, target) : target;
    }
}

