/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ogm.type.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.ogm.dialect.spi.GridDialect;
import org.hibernate.ogm.type.impl.AbstractGenericBasicType;
import org.hibernate.ogm.type.impl.BigDecimalType;
import org.hibernate.ogm.type.impl.BigIntegerType;
import org.hibernate.ogm.type.impl.BooleanType;
import org.hibernate.ogm.type.impl.ByteType;
import org.hibernate.ogm.type.impl.CalendarDateType;
import org.hibernate.ogm.type.impl.CalendarType;
import org.hibernate.ogm.type.impl.ClassType;
import org.hibernate.ogm.type.impl.CollectionType;
import org.hibernate.ogm.type.impl.ComponentType;
import org.hibernate.ogm.type.impl.DateType;
import org.hibernate.ogm.type.impl.DoubleType;
import org.hibernate.ogm.type.impl.EnumType;
import org.hibernate.ogm.type.impl.IntegerType;
import org.hibernate.ogm.type.impl.LongType;
import org.hibernate.ogm.type.impl.ManyToOneType;
import org.hibernate.ogm.type.impl.OneToOneType;
import org.hibernate.ogm.type.impl.PrimitiveByteArrayType;
import org.hibernate.ogm.type.impl.StringType;
import org.hibernate.ogm.type.impl.TimeType;
import org.hibernate.ogm.type.impl.TimestampType;
import org.hibernate.ogm.type.impl.UUIDType;
import org.hibernate.ogm.type.impl.UrlType;
import org.hibernate.ogm.type.spi.GridType;
import org.hibernate.ogm.type.spi.TypeTranslator;
import org.hibernate.ogm.util.impl.CollectionHelper;
import org.hibernate.ogm.util.impl.Log;
import org.hibernate.ogm.util.impl.LoggerFactory;
import org.hibernate.type.AbstractStandardBasicType;
import org.hibernate.type.CustomType;
import org.hibernate.type.Type;
import org.hibernate.type.descriptor.java.BigDecimalTypeDescriptor;
import org.hibernate.type.descriptor.java.BigIntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.BooleanTypeDescriptor;
import org.hibernate.type.descriptor.java.ByteTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarDateTypeDescriptor;
import org.hibernate.type.descriptor.java.CalendarTypeDescriptor;
import org.hibernate.type.descriptor.java.ClassTypeDescriptor;
import org.hibernate.type.descriptor.java.DoubleTypeDescriptor;
import org.hibernate.type.descriptor.java.IntegerTypeDescriptor;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcDateTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimeTypeDescriptor;
import org.hibernate.type.descriptor.java.JdbcTimestampTypeDescriptor;
import org.hibernate.type.descriptor.java.LongTypeDescriptor;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayTypeDescriptor;
import org.hibernate.type.descriptor.java.StringTypeDescriptor;
import org.hibernate.type.descriptor.java.UUIDTypeDescriptor;
import org.hibernate.type.descriptor.java.UrlTypeDescriptor;
import org.hibernate.usertype.UserType;

public class TypeTranslatorImpl
implements TypeTranslator {
    private static final Log log = LoggerFactory.make();
    private final Map<JavaTypeDescriptor<?>, GridType> typeConverter;
    private final GridDialect dialect;

    public TypeTranslatorImpl(GridDialect dialect) {
        this.dialect = dialect;
        HashMap<Object, AbstractGenericBasicType> tmpMap = CollectionHelper.newHashMap(17);
        tmpMap.put(ClassTypeDescriptor.INSTANCE, ClassType.INSTANCE);
        tmpMap.put(LongTypeDescriptor.INSTANCE, LongType.INSTANCE);
        tmpMap.put(IntegerTypeDescriptor.INSTANCE, IntegerType.INSTANCE);
        tmpMap.put(DoubleTypeDescriptor.INSTANCE, DoubleType.INSTANCE);
        tmpMap.put(StringTypeDescriptor.INSTANCE, StringType.INSTANCE);
        tmpMap.put(UrlTypeDescriptor.INSTANCE, UrlType.INSTANCE);
        tmpMap.put(BigDecimalTypeDescriptor.INSTANCE, BigDecimalType.INSTANCE);
        tmpMap.put(BigIntegerTypeDescriptor.INSTANCE, BigIntegerType.INSTANCE);
        tmpMap.put(BooleanTypeDescriptor.INSTANCE, BooleanType.INSTANCE);
        tmpMap.put(ByteTypeDescriptor.INSTANCE, ByteType.INSTANCE);
        tmpMap.put(JdbcDateTypeDescriptor.INSTANCE, DateType.INSTANCE);
        tmpMap.put(JdbcTimestampTypeDescriptor.INSTANCE, TimestampType.INSTANCE);
        tmpMap.put(JdbcTimeTypeDescriptor.INSTANCE, TimeType.INSTANCE);
        tmpMap.put(CalendarDateTypeDescriptor.INSTANCE, CalendarDateType.INSTANCE);
        tmpMap.put(CalendarTypeDescriptor.INSTANCE, CalendarType.INSTANCE);
        tmpMap.put(PrimitiveByteArrayTypeDescriptor.INSTANCE, PrimitiveByteArrayType.INSTANCE);
        tmpMap.put(UUIDTypeDescriptor.INSTANCE, UUIDType.INSTANCE);
        this.typeConverter = Collections.unmodifiableMap(tmpMap);
    }

    @Override
    public GridType getType(Type type) {
        if (type == null) {
            return null;
        }
        GridType dialectType = this.dialect.overrideType(type);
        if (dialectType != null) {
            return dialectType;
        }
        if (type instanceof AbstractStandardBasicType) {
            AbstractStandardBasicType exposedType = (AbstractStandardBasicType)type;
            GridType gridType = this.typeConverter.get(exposedType.getJavaTypeDescriptor());
            if (gridType == null) {
                throw log.unableToFindGridType(exposedType.getJavaTypeDescriptor().getJavaTypeClass().getName());
            }
            return gridType;
        }
        if (type instanceof CustomType) {
            CustomType cType = (CustomType)type;
            UserType userType = cType.getUserType();
            if (userType instanceof org.hibernate.type.EnumType) {
                org.hibernate.type.EnumType enumType = (org.hibernate.type.EnumType)userType;
                return new EnumType(cType, enumType);
            }
        } else {
            if (type instanceof org.hibernate.type.ComponentType) {
                org.hibernate.type.ComponentType componentType = (org.hibernate.type.ComponentType)type;
                return new ComponentType(componentType, this);
            }
            if (type instanceof org.hibernate.type.ManyToOneType) {
                org.hibernate.type.ManyToOneType manyToOneType = (org.hibernate.type.ManyToOneType)type;
                return new ManyToOneType(manyToOneType, this);
            }
            if (type instanceof org.hibernate.type.OneToOneType) {
                org.hibernate.type.OneToOneType oneToOneType = (org.hibernate.type.OneToOneType)type;
                return new OneToOneType(oneToOneType, this);
            }
            if (type instanceof org.hibernate.type.CollectionType) {
                return new CollectionType((org.hibernate.type.CollectionType)type);
            }
        }
        throw log.unableToFindGridType(type.getClass().getName());
    }
}

